/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class WordsToSentencesAnnotatorTest
extends TestCase {
    public void testAnnotator() {
        String text = "I saw Dr. Spock yesterday, he was speaking with Mr. McCoy.  They were walking down Mullholand Dr. talking about www.google.com.  Dr. Spock returns!";
        WordsToSentencesAnnotatorTest.runSentence(text, 3);
        text = "I visited Google Research.  Dr. Spock, Ph.D., was working there and said it's an awful place!  What a waste of Ms. Pacman's last remaining life.";
        WordsToSentencesAnnotatorTest.runSentence(text, 3);
    }

    public static boolean runSentence(String text, int num_sentences) {
        Annotation doc = new Annotation(text);
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit");
        props.setProperty("tokenize.language", "en");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(doc);
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertNotNull((Object)sentences);
        Assert.assertEquals((int)num_sentences, (int)sentences.size());
        return true;
    }

    public void testSentenceSplitting() {
        String text = "Date :\n01/02/2012\nContent :\nSome words are here .\n";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit");
        props.setProperty("ssplit.eolonly", "true");
        props.setProperty("tokenize.whitespace", "true");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation document1 = new Annotation(text);
        pipeline.annotate(document1);
        List sentences = (List)document1.get(CoreAnnotations.SentencesAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)4, (int)sentences.size());
    }

    public void testTokenizeNLsDoesntChangeSsplitResults() {
        String text = "This is one sentence\n\nThis is not another with default ssplit settings.";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit");
        props.setProperty("tokenize.options", "tokenizeNLs");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation document1 = new Annotation(text);
        pipeline.annotate(document1);
        List sentences = (List)document1.get(CoreAnnotations.SentencesAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)1, (int)sentences.size());
        List tokens = (List)document1.get(CoreAnnotations.TokensAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)15, (int)tokens.size());
    }

    public void testDefaultNewlineIsSentenceBreakSettings() {
        String text = "This is one sentence\n\nThis is not another with default ssplit settings.";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation document1 = new Annotation(text);
        pipeline.annotate(document1);
        List sentences = (List)document1.get(CoreAnnotations.SentencesAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)1, (int)sentences.size());
        List tokens = (List)document1.get(CoreAnnotations.TokensAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)13, (int)tokens.size());
    }

    public void testTwoNewlineIsSentenceBreakSettings() {
        String text = "This is \none sentence\n\nThis is not another.";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit");
        props.setProperty("ssplit.newlineIsSentenceBreak", "two");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation document1 = new Annotation(text);
        pipeline.annotate(document1);
        List sentences = (List)document1.get(CoreAnnotations.SentencesAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)2, (int)sentences.size());
        List tokens = (List)document1.get(CoreAnnotations.TokensAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)12, (int)tokens.size());
    }

    public void testAlwaysNewlineIsSentenceBreakSettings() {
        String text = "This is \none sentence\n\nThis is not another.";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit");
        props.setProperty("ssplit.newlineIsSentenceBreak", "always");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation document1 = new Annotation(text);
        pipeline.annotate(document1);
        List sentences = (List)document1.get(CoreAnnotations.SentencesAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)3, (int)sentences.size());
        List tokens = (List)document1.get(CoreAnnotations.TokensAnnotation.class);
        WordsToSentencesAnnotatorTest.assertEquals((int)12, (int)tokens.size());
    }
}

