/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline.demo;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StanfordCoreNlpDemo {
    public static void main(String[] args) throws IOException {
        PrintWriter out2 = args.length > 1 ? new PrintWriter(args[1]) : new PrintWriter(System.out);
        PrintWriter xmlOut = null;
        if (args.length > 2) {
            xmlOut = new PrintWriter(args[2]);
        }
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, lemma, ner, parse, dcoref, sentiment");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation annotation = args.length > 0 ? new Annotation(IOUtils.slurpFileNoExceptions(args[0])) : new Annotation("Kosgi Santosh sent an email to Stanford University. He didn't get a reply.");
        pipeline.annotate(annotation);
        pipeline.prettyPrint(annotation, out2);
        if (xmlOut != null) {
            pipeline.xmlPrint(annotation, xmlOut);
        }
        out2.println();
        out2.println("The top level annotation");
        out2.println(annotation.toShorterString(new String[0]));
        out2.println();
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        if (sentences != null && !sentences.isEmpty()) {
            CoreMap sentence = (CoreMap)sentences.get(0);
            out2.println("The keys of the first sentence's CoreMap are:");
            out2.println(sentence.keySet());
            out2.println();
            out2.println("The first sentence is:");
            out2.println(sentence.toShorterString(new String[0]));
            out2.println();
            out2.println("The first sentence tokens are:");
            for (CoreMap token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                out2.println(token.toShorterString(new String[0]));
            }
            Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            out2.println();
            out2.println("The first sentence parse tree is:");
            tree.pennPrint(out2);
            out2.println();
            out2.println("The first sentence basic dependencies are:");
            out2.println(((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)).toString(SemanticGraph.OutputFormat.LIST));
            out2.println("The first sentence collapsed, CC-processed dependencies are:");
            SemanticGraph graph = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
            out2.println(graph.toString(SemanticGraph.OutputFormat.LIST));
            out2.println("Coreference information");
            Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
            if (corefChains == null) {
                return;
            }
            for (Map.Entry entry : corefChains.entrySet()) {
                out2.println("Chain " + entry.getKey());
                for (CorefChain.CorefMention m : ((CorefChain)entry.getValue()).getMentionsInTextualOrder()) {
                    List tokens = (List)((CoreMap)sentences.get(m.sentNum - 1)).get(CoreAnnotations.TokensAnnotation.class);
                    out2.println("  " + m + ", i.e., 0-based character offsets [" + ((CoreLabel)tokens.get(m.startIndex - 1)).beginPosition() + ", " + ((CoreLabel)tokens.get(m.endIndex - 2)).endPosition() + ")");
                }
            }
            out2.println();
            out2.println("The first sentence overall sentiment rating is " + (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class));
        }
        IOUtils.closeIgnoringExceptions(out2);
        IOUtils.closeIgnoringExceptions(xmlOut);
    }
}

