/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline.webapp;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.XMLOutputter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Nodes;
import nu.xom.xslt.XSLTransform;
import org.apache.commons.lang3.StringEscapeUtils;

public class CoreNLPServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private StanfordCoreNLP pipeline;
    private XSLTransform corenlpTransformer;
    private String defaultFormat = "pretty";
    private static final int MAXIMUM_QUERY_LENGTH = 4096;

    public void init() throws ServletException {
        this.pipeline = new StanfordCoreNLP();
        String xslPath = this.getServletContext().getRealPath("/WEB-INF/data/CoreNLP-to-HTML.xsl");
        try {
            Builder builder = new Builder();
            Document stylesheet = builder.build(new File(xslPath));
            this.corenlpTransformer = new XSLTransform(stylesheet);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("utf-8");
        }
        response.setContentType("text/html; charset=UTF-8");
        this.getServletContext().getRequestDispatcher("/header.jsp").include((ServletRequest)request, (ServletResponse)response);
        this.addResults(request, response);
        this.getServletContext().getRequestDispatcher("/footer.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void addResults(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String input = request.getParameter("input");
        if (input == null) {
            return;
        }
        if ((input = input.trim()).equals("")) {
            return;
        }
        PrintWriter out2 = response.getWriter();
        if (input.length() > 4096) {
            out2.print("<div>This query is too long.  If you want to run very long queries, please download and use our <a href=\"http://nlp.stanford.edu/software/corenlp.shtml\">publicly released distribution</a>.</div>");
            return;
        }
        Annotation annotation = new Annotation(input);
        this.pipeline.annotate(annotation);
        String outputFormat = request.getParameter("outputFormat");
        if (outputFormat == null || outputFormat.trim().equals("")) {
            outputFormat = this.defaultFormat;
        }
        switch (outputFormat) {
            case "xml": {
                this.outputXml(out2, annotation);
                break;
            }
            case "json": {
                this.outputJson(out2, annotation);
                break;
            }
            case "conll": {
                this.outputCoNLL(out2, annotation);
                break;
            }
            case "pretty": {
                this.outputPretty(out2, annotation);
                break;
            }
            default: {
                this.outputVisualise(out2, annotation);
            }
        }
    }

    public void outputVisualise(PrintWriter out2, Annotation annotation) throws ServletException, IOException {
        out2.println("<div id=\"config_error\">");
        out2.println("</div>");
        int visualiserDivPxWidth = 700;
        LinkedHashMap<String, String> nameByAbbrv = new LinkedHashMap<String, String>();
        nameByAbbrv.put("pos", "Part-of-Speech");
        nameByAbbrv.put("ner", "Named Entity Recognition");
        nameByAbbrv.put("coref", "Coreference");
        nameByAbbrv.put("basic_dep", "Basic Dependencies");
        nameByAbbrv.put("collapsed_ccproc_dep", "Enhanced Dependencies");
        for (Map.Entry entry : nameByAbbrv.entrySet()) {
            out2.println("<h2>" + (String)entry.getValue() + ":</h2>");
            out2.println("<div id=\"" + (String)entry.getKey() + "\" style=\"width:" + 700 + "px\">");
            out2.println("    <div id=\"" + (String)entry.getKey() + "_loading\">");
            out2.println("        <p>Loading...</p>");
            out2.println("    </div>");
            out2.println("</div>");
            out2.println("");
        }
        StringWriter xmlOutput = new StringWriter();
        this.pipeline.xmlPrint(annotation, xmlOutput);
        xmlOutput.flush();
        String escapedXml = xmlOutput.toString().replaceAll("\\r\\n|\\r|\\n", "").replace("\"", "\\\"");
        out2.println("<script type=\"text/javascript\">");
        out2.println("// <![CDATA[");
        out2.println("    stanfordXML = \"" + escapedXml + "\";");
        out2.println("// ]]>");
        out2.println("</script>");
        String bratLocation = "../brat";
        out2.println("<script type=\"text/javascript\">");
        out2.println("// <![CDATA[");
        out2.println("    bratLocation = \"../brat\";");
        out2.println("    webFontURLs = [\n        '../brat/static/fonts/Astloch-Bold.ttf',\n        '../brat/static/fonts/PT_Sans-Caption-Web-Regular.ttf',\n        '../brat/static/fonts/Liberation_Sans-Regular.ttf'];");
        out2.println("// ]]>");
        out2.println("</script>");
        out2.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../brat/style-vis.css\"/>");
        out2.println("<script type=\"text/javascript\" src=\"../brat/client/lib/head.load.min.js\"></script>");
        out2.println("<script type=\"text/javascript\" src=\"brat.js\"></script>");
        out2.println("<h>Visualisation provided using the <a href=\"http://brat.nlplab.org/\">brat visualisation/annotation software</a>.</h>");
        out2.println("<br/>");
    }

    public void outputPretty(PrintWriter out2, Annotation annotation) throws ServletException {
        try {
            Document input = XMLOutputter.annotationToDoc(annotation, this.pipeline);
            Nodes output = this.corenlpTransformer.transform(input);
            for (int i = 0; i < output.size(); ++i) {
                out2.print(output.get(i).toXML());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void outputByWriter(Consumer<StringWriter> printer, PrintWriter out2) throws IOException {
        StringWriter output = new StringWriter();
        printer.accept(output);
        output.flush();
        String escapedXml = StringEscapeUtils.escapeHtml4((String)output.toString());
        String[] lines = escapedXml.split("\n");
        out2.print("<div><pre>");
        for (String line : lines) {
            int numSpaces;
            for (numSpaces = 0; numSpaces < line.length() && line.charAt(numSpaces) == ' '; ++numSpaces) {
                out2.print("&nbsp;");
            }
            out2.print(line.substring(numSpaces));
            out2.print("\n");
        }
        out2.print("</pre></div>");
    }

    public void outputXml(PrintWriter out2, Annotation annotation) throws IOException {
        this.outputByWriter(writer -> {
            try {
                this.pipeline.xmlPrint(annotation, (Writer)writer);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }, out2);
    }

    public void outputJson(PrintWriter out2, Annotation annotation) throws IOException {
        this.outputByWriter(writer -> {
            try {
                this.pipeline.jsonPrint(annotation, (Writer)writer);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }, out2);
    }

    public void outputCoNLL(PrintWriter out2, Annotation annotation) throws IOException {
        this.outputByWriter(writer -> {
            try {
                this.pipeline.conllPrint(annotation, (Writer)writer);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }, out2);
    }
}

