/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.process.DocumentPreprocessor;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class DocumentPreprocessorTest
extends TestCase {
    private static final String BASIC_XML_TEST = "<xml><text>The previous test was a lie.  I didn't make this test in my office; I made it at home.</text>\nMy home currently smells like dog vomit.\n<text apartment=\"stinky\">My dog puked everywhere after eating some carrots the other day.\n  Hopefully I have cleaned the last of it, though.</text>\n\nThis tests to see what happens on an empty tag:<text></text><text>It shouldn't include a blank sentence, but it should include this sentence.</text>this is madness...<text>no, this <text> is </text> NESTED!</text>This only prints 'no, this is' instead of 'no, this is NESTED'.  Doesn't do what i would expect, but it's consistent with the old behavior.</xml>";

    private static void runTest(String input, String[] expected) {
        DocumentPreprocessorTest.runTest(input, expected, null, false);
    }

    private static void runTest(String input, String[] expected, String[] sentenceFinalPuncWords, boolean whitespaceTokenize) {
        ArrayList<String> results = new ArrayList<String>();
        DocumentPreprocessor document = new DocumentPreprocessor(new BufferedReader(new StringReader(input)));
        if (sentenceFinalPuncWords != null) {
            document.setSentenceFinalPuncWords(sentenceFinalPuncWords);
        }
        if (whitespaceTokenize) {
            document.setTokenizerFactory(null);
            document.setSentenceDelimiter("\n");
        }
        for (List<HasWord> sentence : document) {
            results.add(SentenceUtils.listToString(sentence));
        }
        DocumentPreprocessorTest.assertEquals((String)("Should be " + expected.length + " sentences but got " + results.size() + ": " + results), (int)expected.length, (int)results.size());
        for (int i = 0; i < results.size(); ++i) {
            DocumentPreprocessorTest.assertEquals((String)("Failed on sentence " + i), (String)expected[i], (String)((String)results.get(i)));
        }
    }

    public void testText() {
        String test = "This is a test of the preprocessor2.  It should split this text into sentences.  I like resting my feet on my desk.  Hopefully the people around my office don't hear me singing along to my music, and if they do, hopefully they aren't annoyed.  My test cases are probably terrifying looks into my psyche.";
        String[] expectedResults = new String[]{"This is a test of the preprocessor2 .", "It should split this text into sentences .", "I like resting my feet on my desk .", "Hopefully the people around my office do n't hear me singing along to my music , and if they do , hopefully they are n't annoyed .", "My test cases are probably terrifying looks into my psyche ."};
        DocumentPreprocessorTest.runTest(test, expectedResults);
    }

    public void testNearFinalPunctuation() {
        String test = "Mount. Annaguan";
        String[] expectedResults = new String[]{"Mount .", "Annaguan"};
        DocumentPreprocessorTest.runTest(test, expectedResults);
    }

    public void testNearFinalPunctuation2() {
        String test = "(I lied.)";
        String[] expectedResults = new String[]{"-LRB- I lied . -RRB-"};
        DocumentPreprocessorTest.runTest(test, expectedResults);
    }

    public void testSetSentencePunctWords() {
        String test = "This is a test of the preprocessor2... it should split this text into sentences? This should be a different sentence.This should be attached to the previous sentence, though.";
        String[] expectedResults = new String[]{"This is a test of the preprocessor2 ...", "it should split this text into sentences ?", "This should be a different sentence.This should be attached to the previous sentence , though ."};
        String[] sentenceFinalPuncWords = new String[]{".", "?", "!", "...", "\n"};
        DocumentPreprocessorTest.runTest(test, expectedResults, sentenceFinalPuncWords, false);
    }

    public void testWhitespaceTokenization() {
        String test = "This is a whitespace tokenized test case . \n  This should be the second sentence    . \n \n  \n\n  This should be the third sentence .  \n  This should be one sentence . The period should not break it . \n This is the fifth sentence , with a weird period at the end.";
        String[] expectedResults = new String[]{"This is a whitespace tokenized test case .", "This should be the second sentence .", "This should be the third sentence .", "This should be one sentence . The period should not break it .", "This is the fifth sentence , with a weird period at the end."};
        DocumentPreprocessorTest.runTest(test, expectedResults, null, true);
    }

    private static void compareXMLResults(String input, String element, String ... expectedResults) {
        ArrayList<String> results = new ArrayList<String>();
        DocumentPreprocessor document = new DocumentPreprocessor(new BufferedReader(new StringReader(input)), DocumentPreprocessor.DocType.XML);
        document.setElementDelimiter(element);
        for (List<HasWord> sentence : document) {
            results.add(SentenceUtils.listToString(sentence));
        }
        DocumentPreprocessorTest.assertEquals((int)expectedResults.length, (int)results.size());
        for (int i = 0; i < results.size(); ++i) {
            DocumentPreprocessorTest.assertEquals((String)expectedResults[i], (String)((String)results.get(i)));
        }
    }

    public void testXMLBasic() {
        String[] expectedResults = new String[]{"The previous test was a lie .", "I did n't make this test in my office ; I made it at home .", "My dog puked everywhere after eating some carrots the other day .", "Hopefully I have cleaned the last of it , though .", "It should n't include a blank sentence , but it should include this sentence .", "no , this is"};
        DocumentPreprocessorTest.compareXMLResults(BASIC_XML_TEST, "text", expectedResults);
    }

    public void testXMLNoResults() {
        DocumentPreprocessorTest.compareXMLResults(BASIC_XML_TEST, "zzzz", new String[0]);
    }

    public void testXMLElementInText() {
        String TAG_IN_TEXT = "<xml><wood>There are many trees in the woods</wood></xml>";
        DocumentPreprocessorTest.compareXMLResults(TAG_IN_TEXT, "wood", "There are many trees in the woods");
    }

    public void testXMLElementNotInText() {
        String TAG_IN_TEXT = "<xml><wood>There are many trees in the forest</wood></xml>";
        DocumentPreprocessorTest.compareXMLResults(TAG_IN_TEXT, "wood", "There are many trees in the forest");
    }

    public void testPlainTextIterator() {
        String test = "This is a one line test . \n";
        String[] expectedResults = new String[]{"This", "is", "a", "one", "line", "test", "."};
        DocumentPreprocessor document = new DocumentPreprocessor(new BufferedReader(new StringReader(test)));
        document.setTokenizerFactory(null);
        document.setSentenceDelimiter("\n");
        Iterator<List<HasWord>> iterator = document.iterator();
        DocumentPreprocessorTest.assertTrue((boolean)iterator.hasNext());
        DocumentPreprocessorTest.assertTrue((boolean)iterator.hasNext());
        List<HasWord> words = iterator.next();
        DocumentPreprocessorTest.assertEquals((int)expectedResults.length, (int)words.size());
        for (int i = 0; i < expectedResults.length; ++i) {
            DocumentPreprocessorTest.assertEquals((String)expectedResults[i], (String)words.get(i).word());
        }
        DocumentPreprocessorTest.assertFalse((boolean)iterator.hasNext());
        DocumentPreprocessorTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            throw new AssertionError((Object)"iterator.next() should have blown up");
        }
        catch (NoSuchElementException noSuchElementException) {
            DocumentPreprocessorTest.assertFalse((boolean)iterator.hasNext());
            return;
        }
    }
}

