/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morphology;
import junit.framework.TestCase;

public class MorphologyTest
extends TestCase {
    private String[] exWords = new String[]{"brethren", "ducks", "saw", "saw", "running", "making", "makking", "stopped", "xopped", "cleaner", "cleaner", "took", "bought", "am", "were", "did", "n't", "wo", "'s", "'s", "ca", "her", "her", "their", "Books", "light-weight", "cease-fire", "John_William_Smith", "Dogs", "were", "AM", "'d", "'s", "'s", "ai", "sha", "them", "US", "Am", "AM", "ARE", "Was", "WERE", "was", "played", "PLAYED", "<br>", "-0800", "an", "out-rode", "viii", "b-", "s", "hath", "'ll", "d", "re", "no", "r", "du"};
    private String[] exTags = new String[]{"NNS", "NNS", "VBD", "NN", "VBG", "VBG", "VBG", "VBD", "VBD", "NN", "JJR", "VBD", "VBD", "VBP", "VBD", "VBD", "RB", "MD", "VBZ", "POS", "MD", "PRP", "PRP$", "PRP$", "NNPS", "JJ", "NN", "NNP", "NNS", "VBD", "VBP", "MD", "VBZ", "POS", "VBP", "MD", "PRP", "PRP", "VBP", "VBP", "VBP", "VBD", "VBD", "VBD", "VBD", "VBD", "SYM", "CD", "DT", "VBD", "FW", "AFX", "VBZ", "VBP", "MD", "MD", "VBP", "VBP", "VBP", "VBP"};
    private String[] exAnswers = new String[]{"brethren", "duck", "see", "saw", "run", "make", "makk", "stop", "xopp", "cleaner", "cleaner", "take", "buy", "be", "be", "do", "not", "will", "be", "'s", "can", "she", "she", "they", "Books", "light-weight", "cease-fire", "John_William_Smith", "dog", "be", "be", "would", "be", "'s", "be", "shall", "they", "we", "be", "be", "be", "be", "be", "be", "play", "play", "<br>", "-0800", "a", "out-ride", "viii", "b-", "be", "have", "will", "would", "be", "know", "be", "do"};

    public void testMorph() {
        assert (this.exWords.length == this.exTags.length);
        assert (this.exWords.length == this.exAnswers.length);
        for (int i = 0; i < this.exWords.length; ++i) {
            WordLemmaTag ans = Morphology.lemmatizeStatic(new WordTag(this.exWords[i], this.exTags[i]));
            MorphologyTest.assertEquals((String)("Stemmed " + this.exWords[i] + '/' + this.exTags[i] + " to lemma " + ans.lemma() + " versus correct " + this.exAnswers[i]), (String)ans.lemma(), (String)this.exAnswers[i]);
        }
    }

    public void testStem() {
        MorphologyTest.assertEquals((String)"John", (String)Morphology.stemStatic(new WordTag("John", "NNP")).word());
        MorphologyTest.assertEquals((String)"Corporations", (String)Morphology.stemStatic(new WordTag("Corporations", "NNPS")).word());
        WordTag hunt = new WordTag("hunting", "V");
        MorphologyTest.assertEquals((String)"hunt", (String)Morphology.stemStatic(hunt).word());
        MorphologyTest.assertEquals((String)"hunt", (String)Morphology.lemmatizeStatic(hunt).lemma());
    }

    public void testDash() {
        Morphology morpha = new Morphology();
        morpha.stem("b-");
    }

    public void testStemStatic() {
        WordTag wt2 = new WordTag("objecting", "VBG");
        WordTag wt = Morphology.stemStatic(wt2);
        MorphologyTest.assertEquals((String)"object", (String)wt.word());
        wt2 = new WordTag("broken", "VBN");
        wt = Morphology.stemStatic(wt2);
        MorphologyTest.assertEquals((String)"break", (String)wt.word());
        wt2 = new WordTag("topoi", "NNS");
        wt = Morphology.stemStatic(wt2);
        MorphologyTest.assertEquals((String)"topos", (String)wt.word());
        wt2 = new WordTag("radii", "NNS");
        wt = Morphology.stemStatic(wt2);
        MorphologyTest.assertEquals((String)"radius", (String)wt.word());
    }
}

