/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class PTBTokenizerITest
extends TestCase {
    private static void compareResults(BufferedReader testReader, List<String> goldResults) {
        PTBTokenizer<CoreLabel> tokenizer = new PTBTokenizer<CoreLabel>(testReader, new CoreLabelTokenFactory(), "");
        ArrayList<String> testResults = new ArrayList<String>();
        while (tokenizer.hasNext()) {
            CoreLabel w = (CoreLabel)tokenizer.next();
            testResults.add(w.word());
        }
        int compareSize = Math.min(goldResults.size(), testResults.size());
        for (int i = 0; i < compareSize; ++i) {
            PTBTokenizerITest.assertEquals((String)goldResults.get(i), (String)((String)testResults.get(i)));
        }
        PTBTokenizerITest.assertEquals((int)goldResults.size(), (int)testResults.size());
    }

    private static BufferedReader getReaderFromInJavaNlp(String filename) throws IOException {
        BufferedReader reader;
        String charset = "utf-8";
        try {
            reader = new BufferedReader(new InputStreamReader(PTBTokenizerITest.class.getResourceAsStream(filename), "utf-8"));
        }
        catch (NullPointerException npe) {
            Map<String, String> env = System.getenv();
            String path = "projects/core/data/edu/stanford/nlp/process" + File.separator + filename;
            String loc = env.get("JAVANLP_HOME");
            if (loc != null) {
                path = loc + File.separator + path;
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "utf-8"));
        }
        return reader;
    }

    public void testLargeDataSet() throws IOException {
        String line;
        BufferedReader goldReader = PTBTokenizerITest.getReaderFromInJavaNlp("ptblexer.gold");
        ArrayList<String> goldResults = new ArrayList<String>();
        while ((line = goldReader.readLine()) != null) {
            goldResults.add(line.trim());
        }
        BufferedReader testReader = PTBTokenizerITest.getReaderFromInJavaNlp("ptblexer.test");
        PTBTokenizerITest.compareResults(testReader, goldResults);
        testReader = PTBTokenizerITest.getReaderFromInJavaNlp("ptblexer.crlf.test");
        PTBTokenizerITest.compareResults(testReader, goldResults);
    }
}

