/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.TSVUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public interface TSVSentenceProcessor {
    public static final List<SentenceField> DEFAULT_SENTENCE_TABLE = Collections.unmodifiableList(Arrays.asList(SentenceField.ID, SentenceField.DEPENDENCIES_STANFORD, SentenceField.DEPENDENCIES_EXTRAS, SentenceField.DEPENDENCIES_MALT, SentenceField.DEPENDENCIES_MALT_ALT1, SentenceField.DEPENDENCIES_MALT_ALT2, SentenceField.WORDS, SentenceField.LEMMAS, SentenceField.POS_TAGS, SentenceField.NER_TAGS, SentenceField.DOC_ID, SentenceField.SENTENCE_INDEX, SentenceField.CORPUS_ID, SentenceField.DOC_CHAR_BEGIN, SentenceField.DOC_CHAR_END, SentenceField.GLOSS));

    public void process(long var1, Annotation var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void runAndExit(InputStream in, PrintStream debugStream, Function<Integer, Integer> cleanup, List<SentenceField> sentenceTableSpec) {
        int exceptions = 0;
        try {
            String line;
            BufferedReader stdin = new BufferedReader(new InputStreamReader(in));
            int linesProcessed = 0;
            long startTime = System.currentTimeMillis();
            while ((line = stdin.readLine()) != null) {
                long id = -1L;
                try {
                    String[] fields = line.split("\t");
                    id = Long.parseLong(fields[0]);
                    Annotation doc = TSVUtils.parseSentence(Optional.of(fields[sentenceTableSpec.indexOf((Object)SentenceField.DOC_ID)]), Optional.of(fields[sentenceTableSpec.indexOf((Object)SentenceField.SENTENCE_INDEX)]), fields[sentenceTableSpec.indexOf((Object)SentenceField.GLOSS)], fields[sentenceTableSpec.indexOf((Object)SentenceField.DEPENDENCIES_STANFORD)], fields[sentenceTableSpec.indexOf((Object)SentenceField.DEPENDENCIES_MALT)], fields[sentenceTableSpec.indexOf((Object)SentenceField.WORDS)], fields[sentenceTableSpec.indexOf((Object)SentenceField.LEMMAS)], fields[sentenceTableSpec.indexOf((Object)SentenceField.POS_TAGS)], fields[sentenceTableSpec.indexOf((Object)SentenceField.NER_TAGS)], Optional.of(fields[sentenceTableSpec.indexOf((Object)SentenceField.ID)]));
                    this.process(id, doc);
                    if (++linesProcessed % 1000 != 0) continue;
                    long currTime = System.currentTimeMillis();
                    long sentPerSec = (long)linesProcessed / ((currTime - startTime) / 1000L);
                    debugStream.println("[" + Redwood.formatTimeDifference(currTime - startTime) + "] Processed " + linesProcessed + " sentences {" + sentPerSec + " sentences / second}... ");
                }
                catch (Exception t) {
                    debugStream.println("CAUGHT EXCEPTION ON SENTENCE ID: " + id + " (-1 if not known)");
                    t.printStackTrace(debugStream);
                    ++exceptions;
                }
            }
            debugStream.println("[" + Redwood.formatTimeDifference(System.currentTimeMillis() - startTime) + "] DONE");
        }
        catch (Exception t) {
            debugStream.println("FATAL EXCEPTION!");
            t.printStackTrace(debugStream);
            ++exceptions;
        }
        finally {
            debugStream.flush();
            debugStream.close();
        }
        System.exit(cleanup.apply(exceptions));
    }

    default public void runAndExit(InputStream in, PrintStream debugStream, Function<Integer, Integer> cleanup) {
        this.runAndExit(in, debugStream, cleanup, DEFAULT_SENTENCE_TABLE);
    }

    public static enum SentenceField {
        ID,
        DEPENDENCIES_STANFORD,
        DEPENDENCIES_EXTRAS,
        DEPENDENCIES_MALT,
        DEPENDENCIES_MALT_ALT1,
        DEPENDENCIES_MALT_ALT2,
        WORDS,
        LEMMAS,
        POS_TAGS,
        NER_TAGS,
        DOC_ID,
        SENTENCE_INDEX,
        CORPUS_ID,
        DOC_CHAR_BEGIN,
        DOC_CHAR_END,
        GLOSS;

    }
}

