/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;

public class WhitespaceTokenizerTest
extends TestCase {
    public final String[] TEST = new String[]{"This is a test . \n This is a second line .", "A \n B \n \n C", "A. B"};
    public final String[][] RESULTS_NO_EOL = new String[][]{{"This", "is", "a", "test", ".", "This", "is", "a", "second", "line", "."}, {"A", "B", "C"}, {"A.", "B"}};
    public final String[][] RESULTS_EOL = new String[][]{{"This", "is", "a", "test", ".", "\n", "This", "is", "a", "second", "line", "."}, {"A", "\n", "B", "\n", "\n", "C"}, {"A.", "B"}};

    public void runTest(TokenizerFactory<? extends HasWord> factory, String[] testStrings, String[][] resultsStrings) {
        for (int i = 0; i < testStrings.length; ++i) {
            Tokenizer<? extends HasWord> tokenizer = factory.getTokenizer(new StringReader(testStrings[i]));
            List<? extends HasWord> tokens = tokenizer.tokenize();
            WhitespaceTokenizerTest.assertEquals((int)resultsStrings[i].length, (int)tokens.size());
            for (int j = 0; j < resultsStrings[i].length; ++j) {
                WhitespaceTokenizerTest.assertEquals((String)resultsStrings[i][j], (String)tokens.get(j).word());
            }
        }
    }

    public void testWordTokenizer() {
        this.runTest(WhitespaceTokenizer.factory(false), this.TEST, this.RESULTS_NO_EOL);
        this.runTest(WhitespaceTokenizer.factory(true), this.TEST, this.RESULTS_EOL);
    }

    public void testCLTokenizer() {
        CoreLabelTokenFactory factory = new CoreLabelTokenFactory();
        this.runTest(new WhitespaceTokenizer.WhitespaceTokenizerFactory<CoreLabel>(factory, false), this.TEST, this.RESULTS_NO_EOL);
        this.runTest(new WhitespaceTokenizer.WhitespaceTokenizerFactory<CoreLabel>(factory, true), this.TEST, this.RESULTS_EOL);
    }
}

