/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.Tree;
import java.util.HashMap;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class SemgrexTest
extends TestCase {
    public void testMatchAll() {
        SemanticGraph graph = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        Set<IndexedWord> words = graph.vertexSet();
        SemgrexPattern pattern = SemgrexPattern.compile("{}");
        SemgrexMatcher matcher = pattern.matcher(graph);
        String[] expectedMatches = new String[]{"ate", "Bill", "muffins", "blueberry"};
        for (int i = 0; i < expectedMatches.length; ++i) {
            SemgrexTest.assertTrue((boolean)matcher.findNextMatchingNode());
        }
        SemgrexTest.assertFalse((boolean)matcher.findNextMatchingNode());
    }

    public void testTest() {
        SemgrexTest.runTest("{}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "Bill", "muffins", "blueberry");
        try {
            SemgrexTest.runTest("{}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "Bill", "muffins", "foo");
            throw new RuntimeException();
        }
        catch (AssertionFailedError assertionFailedError) {
            try {
                SemgrexTest.runTest("{}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "Bill", "muffins");
                throw new RuntimeException();
            }
            catch (AssertionFailedError assertionFailedError2) {
                try {
                    SemgrexTest.runTest("{}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "Bill", "muffins", "blueberry", "blueberry");
                    throw new RuntimeException();
                }
                catch (AssertionFailedError assertionFailedError3) {
                    return;
                }
            }
        }
    }

    public void testWordMatch() {
        SemgrexTest.runTest("{word:Bill}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill");
        SemgrexTest.runTest("!{word:Bill}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "muffins", "blueberry");
        SemgrexTest.runTest("!{word:Fred}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "Bill", "muffins", "blueberry");
        SemgrexTest.runTest("!{word:ate}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins", "blueberry");
        SemgrexTest.runTest("{word:/^(?!Bill).*$/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "muffins", "blueberry");
        SemgrexTest.runTest("{word:/^(?!Fred).*$/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "Bill", "muffins", "blueberry");
        SemgrexTest.runTest("{word:/^(?!ate).*$/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins", "blueberry");
        SemgrexTest.runTest("{word:muffins} >compound {word:blueberry}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "muffins");
        SemgrexTest.runTest("{} << {word:ate}=a", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins", "blueberry");
        SemgrexTest.runTest("{} << !{word:ate}=a", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "blueberry");
        SemgrexTest.runTest("{} << {}=a", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins", "blueberry", "blueberry");
    }

    public void testSimpleDependency() {
        SemgrexTest.runTest("{} << {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins", "blueberry", "blueberry");
        SemgrexTest.runTest("{} >> {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "ate", "ate", "muffins");
        SemgrexTest.runTest("{} < {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins", "blueberry");
        SemgrexTest.runTest("{} > {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "ate", "muffins");
    }

    public void testNamedDependency() {
        SemgrexTest.runTest("{} << {word:ate}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins", "blueberry");
        SemgrexTest.runTest("{} >> {word:blueberry}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "muffins");
        SemgrexTest.runTest("{} >> {word:Bill}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate");
        SemgrexTest.runTest("{} < {word:ate}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill", "muffins");
        SemgrexTest.runTest("{} > {word:blueberry}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "muffins");
        SemgrexTest.runTest("{} > {word:muffins}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate");
    }

    public void testNamedGovernor() {
        SemgrexTest.runTest("{word:blueberry} << {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "blueberry");
        SemgrexTest.runTest("{word:ate} << {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", new String[0]);
        SemgrexTest.runTest("{word:blueberry} >> {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", new String[0]);
        SemgrexTest.runTest("{word:muffins} >> {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "muffins");
        SemgrexTest.runTest("{word:Bill} >> {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", new String[0]);
        SemgrexTest.runTest("{word:muffins} < {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "muffins");
        SemgrexTest.runTest("{word:muffins} > {}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "muffins");
    }

    public void testTwoDependencies() {
        SemgrexTest.runTest("{} >> ({} >> {})", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate");
        SemgrexTest.runTest("{} >> {word:Bill} >> {word:muffins}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate");
        SemgrexTest.runTest("{}=a >> {}=b >> {word:muffins}=c", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "ate", "ate");
        SemgrexTest.runTest("{}=a >> {word:Bill}=b >> {}=c", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "ate", "ate");
        SemgrexTest.runTest("{}=a >> {}=b >> {}=c", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "ate", "ate", "ate", "ate", "ate", "ate", "ate", "ate", "ate", "muffins");
    }

    public void testRegex() {
        SemgrexTest.runTest("{word:/Bill/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill");
        SemgrexTest.runTest("{word:/ill/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", new String[0]);
        SemgrexTest.runTest("{word:/.*ill/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill");
        SemgrexTest.runTest("{word:/.*il/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", new String[0]);
        SemgrexTest.runTest("{word:/.*il.*/}", "[ate subj>Bill dobj>[muffins compound>blueberry]]", "Bill");
    }

    public void testReferencedRegex() {
        SemgrexTest.runTest("{word:/Bill/}", "[ate subj>Bill dobj>[bill det>the]]", "Bill");
        SemgrexTest.runTest("{word:/.*ill/}", "[ate subj>Bill dobj>[bill det>the]]", "Bill", "bill");
        SemgrexTest.runTest("{word:/[Bb]ill/}", "[ate subj>Bill dobj>[bill det>the]]", "Bill", "bill");
    }

    public static SemanticGraph makeComplicatedGraph() {
        SemanticGraph graph = new SemanticGraph();
        String[] words = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"};
        IndexedWord[] nodes = new IndexedWord[words.length];
        for (int i = 0; i < words.length; ++i) {
            IndexedWord word = new IndexedWord("test", 1, i + 1);
            word.setWord(words[i]);
            word.setValue(words[i]);
            nodes[i] = word;
            graph.addVertex(word);
        }
        graph.setRoot(nodes[0]);
        graph.addEdge(nodes[0], nodes[1], EnglishGrammaticalRelations.MODIFIER, 1.0, false);
        graph.addEdge(nodes[0], nodes[2], EnglishGrammaticalRelations.DIRECT_OBJECT, 1.0, false);
        graph.addEdge(nodes[0], nodes[3], EnglishGrammaticalRelations.INDIRECT_OBJECT, 1.0, false);
        graph.addEdge(nodes[1], nodes[4], EnglishGrammaticalRelations.MARKER, 1.0, false);
        graph.addEdge(nodes[2], nodes[4], EnglishGrammaticalRelations.EXPLETIVE, 1.0, false);
        graph.addEdge(nodes[3], nodes[4], EnglishGrammaticalRelations.ADJECTIVAL_COMPLEMENT, 1.0, false);
        graph.addEdge(nodes[4], nodes[5], EnglishGrammaticalRelations.ADJECTIVAL_MODIFIER, 1.0, false);
        graph.addEdge(nodes[4], nodes[6], EnglishGrammaticalRelations.ADVERBIAL_MODIFIER, 1.0, false);
        graph.addEdge(nodes[4], nodes[8], EnglishGrammaticalRelations.MODIFIER, 1.0, false);
        graph.addEdge(nodes[5], nodes[7], EnglishGrammaticalRelations.POSSESSION_MODIFIER, 1.0, false);
        graph.addEdge(nodes[6], nodes[7], EnglishGrammaticalRelations.POSSESSIVE_MODIFIER, 1.0, false);
        graph.addEdge(nodes[7], nodes[8], EnglishGrammaticalRelations.AGENT, 1.0, false);
        graph.addEdge(nodes[8], nodes[9], EnglishGrammaticalRelations.DETERMINER, 1.0, false);
        return graph;
    }

    public void testComplicatedGraph() {
        SemanticGraph graph = SemgrexTest.makeComplicatedGraph();
        SemgrexTest.runTest("{} < {word:A}", graph, "B", "C", "D");
        SemgrexTest.runTest("{} > {word:E}", graph, "B", "C", "D");
        SemgrexTest.runTest("{} > {word:J}", graph, "I");
        SemgrexTest.runTest("{} < {word:E}", graph, "F", "G", "I");
        SemgrexTest.runTest("{} < {word:I}", graph, "J");
        SemgrexTest.runTest("{} << {word:A}", graph, "B", "C", "D", "E", "F", "G", "H", "I", "J");
        SemgrexTest.runTest("{} << {word:B}", graph, "E", "F", "G", "H", "I", "J");
        SemgrexTest.runTest("{} << {word:C}", graph, "E", "F", "G", "H", "I", "J");
        SemgrexTest.runTest("{} << {word:D}", graph, "E", "F", "G", "H", "I", "J");
        SemgrexTest.runTest("{} << {word:E}", graph, "F", "G", "H", "I", "J");
        SemgrexTest.runTest("{} << {word:F}", graph, "H", "I", "J");
        SemgrexTest.runTest("{} << {word:G}", graph, "H", "I", "J");
        SemgrexTest.runTest("{} << {word:H}", graph, "I", "J");
        SemgrexTest.runTest("{} << {word:I}", graph, "J");
        SemgrexTest.runTest("{} << {word:J}", graph, new String[0]);
        SemgrexTest.runTest("{} << {word:K}", graph, new String[0]);
        SemgrexTest.runTest("{} >> {word:A}", graph, new String[0]);
        SemgrexTest.runTest("{} >> {word:B}", graph, "A");
        SemgrexTest.runTest("{} >> {word:C}", graph, "A");
        SemgrexTest.runTest("{} >> {word:D}", graph, "A");
        SemgrexTest.runTest("{} >> {word:E}", graph, "A", "B", "C", "D");
        SemgrexTest.runTest("{} >> {word:F}", graph, "A", "B", "C", "D", "E");
        SemgrexTest.runTest("{} >> {word:G}", graph, "A", "B", "C", "D", "E");
        SemgrexTest.runTest("{} >> {word:H}", graph, "A", "B", "C", "D", "E", "F", "G");
        SemgrexTest.runTest("{} >> {word:I}", graph, "A", "B", "C", "D", "E", "F", "G", "H");
        SemgrexTest.runTest("{} >> {word:J}", graph, "A", "B", "C", "D", "E", "F", "G", "H", "I");
        SemgrexTest.runTest("{} >> {word:K}", graph, new String[0]);
    }

    public void testRelationType() {
        SemanticGraph graph = SemgrexTest.makeComplicatedGraph();
        SemgrexTest.runTest("{} <<mod {}", graph, "B", "E", "F", "G", "H", "I", "I", "J", "J");
        SemgrexTest.runTest("{} >>det {}", graph, "A", "B", "C", "D", "E", "F", "G", "H", "I");
        SemgrexTest.runTest("{} >>det {word:J}", graph, "A", "B", "C", "D", "E", "F", "G", "H", "I");
    }

    public void testExactDepthRelations() {
        SemanticGraph graph = SemgrexTest.makeComplicatedGraph();
        SemgrexTest.runTest("{} 2,3<< {word:A}", graph, "E", "F", "G", "I");
        SemgrexTest.runTest("{} 2,2<< {word:A}", graph, "E");
        SemgrexTest.runTest("{} 1,2<< {word:A}", graph, "B", "C", "D", "E");
        SemgrexTest.runTest("{} 0,2<< {word:A}", graph, "B", "C", "D", "E");
        SemgrexTest.runTest("{} 0,10<< {word:A}", graph, "B", "C", "D", "E", "F", "G", "H", "I", "J");
        SemgrexTest.runTest("{} 0,10>> {word:J}", graph, "A", "B", "C", "D", "E", "F", "G", "H", "I");
        SemgrexTest.runTest("{} 2,3>> {word:J}", graph, "B", "C", "D", "E", "F", "G", "H");
        SemgrexTest.runTest("{} 2,2>> {word:J}", graph, "E", "H");
        SemgrexTest.runTest(SemgrexPattern.compile("{} 2>> {word:J}"), graph, "E", "H");
        SemgrexTest.runTest("{} 1,2>> {word:J}", graph, "E", "H", "I");
    }

    public void testMultipleDepths() {
        SemanticGraph graph = SemgrexTest.makeComplicatedGraph();
        SemgrexTest.runTest("{} 3,3<< {word:A}", graph, "F", "G", "I");
        SemgrexTest.runTest("{} 4,4<< {word:A}", graph, "H", "J");
        SemgrexTest.runTest("{} 5,5<< {word:A}", graph, "I");
        SemgrexTest.runTest("{} 6,6<< {word:A}", graph, "J");
    }

    public void testNamedNode() {
        SemanticGraph graph = SemgrexTest.makeComplicatedGraph();
        SemgrexTest.runTest("{} >dobj ({} >expl {})", graph, "A");
        SemgrexPattern pattern = SemgrexPattern.compile("{} >dobj ({} >expl {}=foo)");
        SemgrexMatcher matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)1, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"E", (String)matcher.getNode("foo").toString());
        SemgrexTest.assertEquals((String)"A", (String)matcher.getMatch().toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{} >dobj ({} >expl {}=foo) >mod {}");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)1, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"E", (String)matcher.getNode("foo").toString());
        SemgrexTest.assertEquals((String)"A", (String)matcher.getMatch().toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{} >dobj ({} >expl {}=foo) >mod ({} >mark {})");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)1, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"E", (String)matcher.getNode("foo").toString());
        SemgrexTest.assertEquals((String)"A", (String)matcher.getMatch().toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{} >dobj ({} >expl {}=foo) >mod ({} > {})");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)1, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"E", (String)matcher.getNode("foo").toString());
        SemgrexTest.assertEquals((String)"A", (String)matcher.getMatch().toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{} >dobj ({} >expl {}=foo) >mod ({} > {}=foo)");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)1, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"E", (String)matcher.getNode("foo").toString());
        SemgrexTest.assertEquals((String)"A", (String)matcher.getMatch().toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{} >dobj ({} >expl {}=foo) >mod ({}=foo > {})");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertFalse((boolean)matcher.find());
    }

    public void testPartition() {
        SemanticGraph graph = SemgrexTest.makeComplicatedGraph();
        SemgrexTest.runTest("{}=a >> {word:E}", graph, "A", "B", "C", "D");
        SemgrexTest.runTest("{}=a >> {word:E} : {}=a >> {word:B}", graph, "A");
    }

    public void testEqualsRelation() {
        SemanticGraph graph = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        SemgrexPattern pattern = SemgrexPattern.compile("{} >> ({}=a == {}=b)");
        SemgrexMatcher matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{} >> {}=a >> {}=b : {}=a == {}=b");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
    }

    public void testNotEquals() {
        SemanticGraph graph = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        SemgrexPattern pattern = SemgrexPattern.compile("{} >> {}=a >> {}=b : {}=a !== {}=b");
        SemgrexMatcher matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("b").toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{} >> {}=a >> ({}=b !== {}=a)");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"Bill", (String)matcher.getNode("b").toString());
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)2, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getMatch().toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("b").toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
    }

    public void testInitialConditions() {
        SemanticGraph graph = SemgrexTest.makeComplicatedGraph();
        SemgrexPattern pattern = SemgrexPattern.compile("{}=a >> {}=b : {}=a >> {}=c");
        HashMap<String, IndexedWord> variables = new HashMap<String, IndexedWord>();
        variables.put("b", graph.getNodeByIndex(5));
        variables.put("c", graph.getNodeByIndex(2));
        SemgrexMatcher matcher = pattern.matcher(graph, variables);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((int)3, (int)matcher.getNodeNames().size());
        SemgrexTest.assertEquals((String)"A", (String)matcher.getNode("a").toString());
        SemgrexTest.assertEquals((String)"E", (String)matcher.getNode("b").toString());
        SemgrexTest.assertEquals((String)"B", (String)matcher.getNode("c").toString());
        SemgrexTest.assertEquals((String)"A", (String)matcher.getMatch().toString());
        SemgrexTest.assertFalse((boolean)matcher.find());
    }

    public void testIndex() {
        SemanticGraph graph = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        SemgrexTest.runTest("{idx:0}", graph, "ate");
        SemgrexTest.runTest("{idx:1}", graph, "Bill");
        SemgrexTest.runTest("{idx:2}", graph, "muffins");
        SemgrexTest.runTest("{idx:3}", graph, "blueberry");
        SemgrexTest.runTest("{idx:4}", graph, new String[0]);
    }

    public void testLemma() {
        SemanticGraph graph = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        for (IndexedWord word : graph.vertexSet()) {
            word.setLemma(word.word());
        }
        SemgrexTest.runTest("{lemma:ate}", graph, "ate");
        Tree tree = Tree.valueOf("(ROOT (S (NP (PRP I)) (VP (VBP love) (NP (DT the) (NN display))) (. .)))");
        graph = SemanticGraphFactory.generateCCProcessedDependencies(tree);
        for (IndexedWord word : graph.vertexSet()) {
            word.setLemma(word.word());
        }
        SemgrexTest.runTest("{}=Obj <dobj {lemma:love}=Pred", graph, "display/NN");
        SemgrexTest.runTest("{}=Obj <dobj {}=Pred", graph, "display/NN");
        SemgrexTest.runTest("{lemma:love}=Pred >dobj {}=Obj ", graph, "love/VBP");
    }

    public void testNamedRelation() {
        SemanticGraph graph = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        SemgrexPattern pattern = SemgrexPattern.compile("{idx:0}=gov >>=foo {idx:3}=dep");
        SemgrexMatcher matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getNode("gov").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("dep").toString());
        SemgrexTest.assertEquals((String)"compound", (String)matcher.getRelnString("foo"));
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{idx:3}=dep <<=foo {idx:0}=gov");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((String)"ate", (String)matcher.getNode("gov").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("dep").toString());
        SemgrexTest.assertEquals((String)"dobj", (String)matcher.getRelnString("foo"));
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{idx:3}=dep <=foo {idx:2}=gov");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("gov").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("dep").toString());
        SemgrexTest.assertEquals((String)"compound", (String)matcher.getRelnString("foo"));
        SemgrexTest.assertFalse((boolean)matcher.find());
        pattern = SemgrexPattern.compile("{idx:2}=gov >=foo {idx:3}=dep");
        matcher = pattern.matcher(graph);
        SemgrexTest.assertTrue((boolean)matcher.find());
        SemgrexTest.assertEquals((String)"muffins", (String)matcher.getNode("gov").toString());
        SemgrexTest.assertEquals((String)"blueberry", (String)matcher.getNode("dep").toString());
        SemgrexTest.assertEquals((String)"compound", (String)matcher.getRelnString("foo"));
        SemgrexTest.assertFalse((boolean)matcher.find());
    }

    public static void outputResults(String pattern, String graph, String ... ignored) {
        SemgrexTest.outputResults(SemgrexPattern.compile(pattern), SemanticGraph.valueOf(graph), new String[0]);
    }

    public static void outputResults(String pattern, SemanticGraph graph, String ... ignored) {
        SemgrexTest.outputResults(SemgrexPattern.compile(pattern), graph, new String[0]);
    }

    public static void outputResults(SemgrexPattern pattern, SemanticGraph graph, String ... ignored) {
        System.out.println("Matching pattern " + pattern + " to\n" + graph + "  :" + (pattern.matcher(graph).matches() ? "matches" : "doesn't match"));
        System.out.println();
        pattern.prettyPrint();
        System.out.println();
        SemgrexMatcher matcher = pattern.matcher(graph);
        while (matcher.find()) {
            Set<String> relNames;
            System.out.println("  " + matcher.getMatch());
            Set<String> nodeNames = matcher.getNodeNames();
            if (nodeNames != null && nodeNames.size() > 0) {
                for (String name : nodeNames) {
                    System.out.println("    " + name + ": " + matcher.getNode(name));
                }
            }
            if ((relNames = matcher.getRelationNames()) == null) continue;
            for (String name : relNames) {
                System.out.println("    " + name + ": " + matcher.getRelnString(name));
            }
        }
    }

    public static void comparePatternToString(String pattern) {
        SemgrexPattern semgrex = SemgrexPattern.compile(pattern);
        String tostring = semgrex.toString();
        tostring = tostring.replaceAll(" +", " ");
        SemgrexTest.assertEquals((String)pattern.trim(), (String)tostring.trim());
    }

    public static void runTest(String pattern, String graph, String ... expectedMatches) {
        SemgrexTest.comparePatternToString(pattern);
        SemgrexTest.runTest(SemgrexPattern.compile(pattern), SemanticGraph.valueOf(graph), expectedMatches);
    }

    public static void runTest(String pattern, SemanticGraph graph, String ... expectedMatches) {
        SemgrexTest.comparePatternToString(pattern);
        SemgrexTest.runTest(SemgrexPattern.compile(pattern), graph, expectedMatches);
    }

    public static void runTest(SemgrexPattern pattern, SemanticGraph graph, String ... expectedMatches) {
        IntCounter<String> counts = new IntCounter<String>();
        for (int i = 0; i < expectedMatches.length; ++i) {
            counts.incrementCount(expectedMatches[i]);
        }
        IntCounter originalCounts = new IntCounter(counts);
        SemgrexMatcher matcher = pattern.matcher(graph);
        for (int i = 0; i < expectedMatches.length; ++i) {
            if (!matcher.find()) {
                throw new AssertionFailedError("Expected " + expectedMatches.length + " matches for pattern " + pattern + " on " + graph + ", only got " + i);
            }
            String match = matcher.getMatch().toString();
            if (!counts.containsKey(match)) {
                throw new AssertionFailedError("Unexpected match " + match + " for pattern " + pattern + " on " + graph);
            }
            counts.decrementCount(match);
            if (!(counts.getCount(match) < 0.0)) continue;
            throw new AssertionFailedError("Found too many matches for " + match + " for pattern " + pattern + " on " + graph);
        }
        if (matcher.findNextMatchingNode()) {
            throw new AssertionFailedError("Found more than " + expectedMatches.length + " matches for pattern " + pattern + " on " + graph + "... extra match is " + matcher.getMatch());
        }
    }
}

