/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.demo;

import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.logging.Redwood;

public class SemgrexDemo {
    private static Redwood.RedwoodChannels log = Redwood.channels(SemgrexDemo.class);

    public static void main(String[] args) {
        String treeString = "(ROOT  (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))";
        Tree tree = Tree.valueOf(treeString);
        SemanticGraph graph = SemanticGraphFactory.generateUncollapsedDependencies(tree);
        EnglishTreebankParserParams params = new EnglishTreebankParserParams();
        GrammaticalStructureFactory gsf = params.treebankLanguagePack().grammaticalStructureFactory(params.treebankLanguagePack().punctuationWordRejectFilter(), params.typedDependencyHeadFinder());
        GrammaticalStructure gs = gsf.newGrammaticalStructure(tree);
        log.info(graph);
        SemgrexPattern semgrex = SemgrexPattern.compile("{}=A <<nsubj {}=B");
        SemgrexMatcher matcher = semgrex.matcher(graph);
        while (matcher.find()) {
            log.info(matcher.getNode("A") + " <<nsubj " + matcher.getNode("B"));
        }
    }
}

