/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddDep;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import java.io.StringWriter;

public class AddNode
extends SsurgeonEdit {
    public static final String LABEL = "addNode";
    String nodeString = null;
    String nodeName = null;

    public AddNode(String nodeString, String nodeName) {
        this.nodeString = nodeString;
        this.nodeName = nodeName;
    }

    public static AddNode createAddNode(String nodeString, String nodeName) {
        return new AddNode(nodeString, nodeName);
    }

    public static AddNode createAddNode(IndexedWord node, String nodeName) {
        String nodeString = AddDep.cheapWordToString(node);
        return new AddNode(nodeString, nodeName);
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord newNode = AddDep.fromCheapString(this.nodeString);
        sg.addVertex(newNode);
        this.addNamedNode(newNode, this.nodeName);
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-nodearg");
        buf.write(" ");
        buf.write("\"");
        buf.write(this.nodeString);
        buf.write("\"\t");
        buf.write("-name");
        buf.write("\t");
        buf.write(this.nodeName);
        return buf.toString();
    }
}

