/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.util.Generics;
import java.io.StringWriter;
import java.util.Set;

public class DeleteGraphFromNode
extends SsurgeonEdit {
    public static final String LABEL = "delete";
    String destroyNodeName;

    public DeleteGraphFromNode(String destroyNodeName) {
        this.destroyNodeName = destroyNodeName;
    }

    public static DeleteGraphFromNode fromArgs(String args) {
        return new DeleteGraphFromNode(args.trim());
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-node");
        buf.write(" ");
        buf.write(this.destroyNodeName);
        return buf.toString();
    }

    protected static void crawl(IndexedWord vertex, SemanticGraph sg, Set<IndexedWord> seenVerts) {
        seenVerts.add(vertex);
        for (SemanticGraphEdge edge : sg.incomingEdgeIterable(vertex)) {
            IndexedWord gov = edge.getGovernor();
            if (seenVerts.contains(gov)) continue;
            DeleteGraphFromNode.crawl(gov, sg, seenVerts);
        }
        for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(vertex)) {
            IndexedWord dep = edge.getDependent();
            if (seenVerts.contains(dep)) continue;
            DeleteGraphFromNode.crawl(dep, sg, seenVerts);
        }
    }

    protected static Set<IndexedWord> crawl(IndexedWord vertex, SemanticGraph sg) {
        Set<IndexedWord> seen = Generics.newHashSet();
        DeleteGraphFromNode.crawl(vertex, sg, seen);
        return seen;
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord seedNode = this.getNamedNode(this.destroyNodeName, sm);
        if (sg.containsVertex(seedNode)) {
            Set<IndexedWord> nodesToDestroy = DeleteGraphFromNode.crawl(seedNode, sg);
            for (IndexedWord node : nodesToDestroy) {
                sg.removeVertex(node);
            }
            sg.resetRoots();
        }
    }
}

