/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.StringWriter;

public class RemoveEdge
extends SsurgeonEdit {
    public static final String LABEL = "removeEdge";
    protected GrammaticalRelation relation;
    protected String govName;
    protected String depName;
    public static final String WILDCARD_NODE = "**WILDNODE**";

    public RemoveEdge(GrammaticalRelation relation, String govName, String depName) {
        this.relation = relation;
        this.govName = govName;
        this.depName = depName;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-reln");
        buf.write(" ");
        buf.write(this.relation.toString());
        buf.write("\t");
        buf.write("-gov");
        buf.write(" ");
        buf.write(this.govName);
        buf.write("\t");
        buf.write("-dep");
        buf.write(" ");
        buf.write(this.depName);
        return buf.toString();
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        block6: {
            IndexedWord depNode;
            IndexedWord govNode;
            boolean depWild;
            boolean govWild;
            block5: {
                govWild = this.govName.equals(WILDCARD_NODE);
                depWild = this.depName.equals(WILDCARD_NODE);
                govNode = this.getNamedNode(this.govName, sm);
                depNode = this.getNamedNode(this.depName, sm);
                if (govNode == null || depNode == null) break block5;
                SemanticGraphEdge edge = sg.getEdge(govNode, depNode, this.relation);
                if (edge == null) break block6;
                boolean bl = sg.removeEdge(edge);
                break block6;
            }
            if (depNode != null && govWild) {
                for (SemanticGraphEdge edge : sg.incomingEdgeIterable(depNode)) {
                    if (!edge.getRelation().equals(this.relation) || !sg.containsEdge(edge)) continue;
                    sg.removeEdge(edge);
                }
            } else if (govNode != null && depWild) {
                for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(govNode)) {
                    if (!edge.getRelation().equals(this.relation) || !sg.containsEdge(edge)) continue;
                    sg.removeEdge(edge);
                }
            }
        }
    }

    public String getDepName() {
        return this.depName;
    }

    public String getGovName() {
        return this.govName;
    }

    public String getRelationName() {
        return this.relation.toString();
    }
}

