/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.sentiment.RNNOptions;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.sentiment.SentimentTraining;
import edu.stanford.nlp.sentiment.SentimentUtils;
import edu.stanford.nlp.trees.Tree;
import java.util.List;
import junit.framework.TestCase;

public class SentimentTrainingITest
extends TestCase {
    static final String TRAIN_PATH = "projects/core/data/edu/stanford/nlp/sentiment/onesent.txt";

    public void testGradientCheck() {
        List<Tree> trainingTrees = SentimentUtils.readTreesWithGoldLabels(TRAIN_PATH);
        RNNOptions op = new RNNOptions();
        op.numHid = 5;
        SentimentModel model = new SentimentModel(op, trainingTrees);
        SentimentTrainingITest.assertTrue((String)("Gradient check failed with random seed of " + op.randomSeed), (boolean)SentimentTraining.runGradientCheck(model, trainingTrees));
    }

    public void testRegularizationGradientCheck() {
        List<Tree> trainingTrees = SentimentUtils.readTreesWithGoldLabels(TRAIN_PATH);
        RNNOptions op = new RNNOptions();
        op.numHid = 5;
        op.trainOptions.regTransformMatrix = 10.0;
        op.trainOptions.regTransformTensor = 10.0;
        op.trainOptions.regClassification = 10.0;
        op.trainOptions.regWordVector = 10.0;
        SentimentModel model = new SentimentModel(op, trainingTrees);
        SentimentTrainingITest.assertTrue((String)("Gradient check failed with random seed of " + op.randomSeed), (boolean)SentimentTraining.runGradientCheck(model, trainingTrees));
    }
}

