/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.SentimentClass;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SimpleSentiment {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SimpleSentiment.class);
    private static Lazy<StanfordCoreNLP> pipeline = Lazy.of(() -> {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma");
        props.setProperty("language", "english");
        props.setProperty("ssplit.isOneSentence", "true");
        props.setProperty("tokenize.class", "PTBTokenizer");
        props.setProperty("tokenize.language", "en");
        return new StanfordCoreNLP(props);
    });
    private static final Pattern alpha = Pattern.compile("[a-zA-Z]+");
    private static final Pattern number = Pattern.compile("[0-9]+");
    private final Classifier<SentimentClass, String> impl;

    private static Counter<String> featurize(CoreMap sentence) {
        ClassicCounter<String> features = new ClassicCounter<String>();
        String lastLemma = "^";
        for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
            String lemma = token.lemma().toLowerCase();
            if (number.matcher(lemma).matches()) {
                features.incrementCount("**num**");
            } else {
                features.incrementCount(lemma);
            }
            if (!alpha.matcher(lemma).matches()) continue;
            features.incrementCount(lastLemma + "__" + lemma);
            lastLemma = lemma;
        }
        features.incrementCount(lastLemma + "__$");
        return features;
    }

    private SimpleSentiment(Classifier<SentimentClass, String> impl) {
        this.impl = impl;
    }

    public SentimentClass classify(CoreMap sentence) {
        Counter<String> features = SimpleSentiment.featurize(sentence);
        RVFDatum datum = new RVFDatum(features);
        return this.impl.classOf(datum);
    }

    public SentimentClass classify(String text) {
        Annotation ann = new Annotation(text);
        pipeline.get().annotate(ann);
        CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        Counter<String> features = SimpleSentiment.featurize(sentence);
        RVFDatum datum = new RVFDatum(features);
        return this.impl.classOf(datum);
    }

    public static SimpleSentiment train(Stream<SentimentDatum> data, Optional<OutputStream> modelLocation) {
        boolean useL1 = true;
        double sigma = 1.0;
        int featureCountThreshold = 5;
        Redwood.Util.forceTrack("Featurizing");
        RVFDataset dataset = new RVFDataset();
        AtomicInteger datasize = new AtomicInteger(0);
        ClassicCounter distribution = new ClassicCounter();
        ((Stream)((Stream)data.unordered()).parallel()).map(datum -> {
            if (datasize.incrementAndGet() % 10000 == 0) {
                Redwood.Util.log("Added " + datasize.get() + " datums");
            }
            return new RVFDatum<SentimentClass, String>(SimpleSentiment.featurize(datum.asCoreMap()), datum.sentiment);
        }).forEach(x -> {
            RVFDataset rVFDataset = dataset;
            synchronized (rVFDataset) {
                distribution.incrementCount(x.label());
                dataset.add(x);
            }
        });
        Redwood.Util.endTrack("Featurizing");
        Redwood.Util.startTrack("Distribution");
        for (SentimentClass label : SentimentClass.values()) {
            Redwood.Util.log(String.format("%7d", (int)distribution.getCount((Object)label)) + "   " + (Object)((Object)label));
        }
        Redwood.Util.endTrack("Distribution");
        Redwood.Util.forceTrack("Training");
        if (featureCountThreshold > 1) {
            dataset.applyFeatureCountThreshold(featureCountThreshold);
        }
        dataset.randomize(42L);
        LinearClassifierFactory factory = new LinearClassifierFactory();
        factory.setVerbose(true);
        try {
            factory.setMinimizerCreator(() -> {
                QNMinimizer minimizer = new QNMinimizer();
                if (useL1) {
                    minimizer.useOWLQN(true, 1.0 / (sigma * sigma));
                } else {
                    factory.setSigma(sigma);
                }
                return minimizer;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        factory.setSigma(sigma);
        Classifier classifier = factory.trainClassifier((GeneralDataset)dataset);
        modelLocation.ifPresent(arg_0 -> SimpleSentiment.lambda$train$465((LinearClassifier)classifier, arg_0));
        Redwood.Util.endTrack("Training");
        Redwood.Util.forceTrack("Evaluating");
        factory.setVerbose(false);
        double sumAccuracy = 0.0;
        ClassicCounter<SentimentClass> sumP = new ClassicCounter<SentimentClass>();
        ClassicCounter sumR = new ClassicCounter();
        int numFolds = 4;
        for (int fold = 0; fold < numFolds; ++fold) {
            Pair trainTest = dataset.splitOutFold(fold, numFolds);
            LinearClassifier foldClassifier = factory.trainClassifierWithInitialWeights((GeneralDataset)trainTest.first, classifier);
            sumAccuracy += foldClassifier.evaluateAccuracy((GeneralDataset)trainTest.second);
            for (SentimentClass label : SentimentClass.values()) {
                Pair<Double, Double> pr = foldClassifier.evaluatePrecisionAndRecall((GeneralDataset)trainTest.second, label);
                sumP.incrementCount(label, (Double)pr.first);
                sumP.incrementCount(label, (Double)pr.second);
            }
        }
        DecimalFormat df = new DecimalFormat("0.000%");
        log.info("----------");
        double aveAccuracy = sumAccuracy / (double)numFolds;
        log.info("" + numFolds + "-fold accuracy: " + df.format(aveAccuracy));
        log.info("");
        for (SentimentClass label : SentimentClass.values()) {
            double p = sumP.getCount((Object)label) / (double)numFolds;
            double r = sumR.getCount((Object)label) / (double)numFolds;
            log.info((Object)((Object)label) + " (P)  = " + df.format(p));
            log.info((Object)((Object)label) + " (R)  = " + df.format(r));
            log.info((Object)((Object)label) + " (F1) = " + df.format(2.0 * p * r / (p + r)));
            log.info("");
        }
        log.info("----------");
        Redwood.Util.endTrack("Evaluating");
        return new SimpleSentiment(classifier);
    }

    private static Stream<SentimentDatum> imdb(String path, SentimentClass label) {
        return StreamSupport.stream(IOUtils.iterFilesRecursive(new File(path)).spliterator(), true).map(x -> {
            try {
                return new SentimentDatum(IOUtils.slurpFile(x), label);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        });
    }

    private static Stream<SentimentDatum> stanford(String path) {
        return StreamSupport.stream(IOUtils.readLines(path).spliterator(), true).map(line -> {
            String[] fields = line.split("\t");
            if (fields.length < 4 || "Sentiment".equalsIgnoreCase(fields[3]) || fields[2].equals("")) {
                return new SentimentDatum("Cats have tails", SentimentClass.NEUTRAL);
            }
            String text = fields[2];
            int sentiment = Integer.parseInt(fields[3]);
            return new SentimentDatum(text, SentimentClass.fromInt(sentiment));
        });
    }

    private static Stream<SentimentDatum> twitter(String path) {
        return StreamSupport.stream(IOUtils.readLines(path).spliterator(), true).map(line -> {
            List<String> fields = Arrays.asList(line.split(","));
            if (fields.size() < 3 || "Sentiment".equalsIgnoreCase(fields.get(1)) || fields.get(3).equals("")) {
                return new SentimentDatum("Cats have tails", SentimentClass.NEUTRAL);
            }
            int sentiment = Integer.parseInt(fields.get(1));
            String text = StringUtils.join(fields.subList(3, fields.size()), ",");
            return new SentimentDatum(text, SentimentClass.fromInt(sentiment));
        });
    }

    private static Stream<SentimentDatum> unlabelled(String path) throws IOException {
        return StreamSupport.stream(IOUtils.iterFilesRecursive(new File(path)).spliterator(), true).flatMap(x -> new Document(IOUtils.slurpReader(IOUtils.readerFromFile(x))).sentences().stream().map(y -> new SentimentDatum(y.text(), SentimentClass.NEUTRAL)));
    }

    public static void main(String[] args) throws IOException {
        RedwoodConfiguration.standard().apply();
        Redwood.Util.startTrack("main");
        Stream<SentimentDatum> data = Stream.concat(Stream.concat(Stream.concat(SimpleSentiment.imdb("/users/gabor/tmp/aclImdb/train/pos", SentimentClass.POSITIVE), SimpleSentiment.imdb("/users/gabor/tmp/aclImdb/train/neg", SentimentClass.NEGATIVE)), Stream.concat(SimpleSentiment.imdb("/users/gabor/tmp/aclImdb/test/pos", SentimentClass.POSITIVE), SimpleSentiment.imdb("/users/gabor/tmp/aclImdb/test/neg", SentimentClass.NEGATIVE))), Stream.concat(Stream.concat(SimpleSentiment.stanford("/users/gabor/tmp/train.tsv"), SimpleSentiment.stanford("/users/gabor/tmp/test.tsv")), Stream.concat(SimpleSentiment.twitter("/users/gabor/tmp/twitter.csv"), SimpleSentiment.unlabelled("/users/gabor/tmp/wikipedia"))));
        OutputStream stream = IOUtils.getFileOutputStream("/users/gabor/tmp/model.ser.gz");
        SimpleSentiment classifier = SimpleSentiment.train(data, Optional.of(stream));
        stream.close();
        log.info(new Object[]{classifier.classify("I think life is great")});
        Redwood.Util.endTrack("main");
    }

    private static /* synthetic */ void lambda$train$465(LinearClassifier classifier, OutputStream stream) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(stream);
            oos.writeObject(classifier);
            oos.close();
        }
        catch (IOException e) {
            log.err("Could not save model to stream!");
        }
    }

    private static class SentimentDatum {
        public final String sentence;
        public final SentimentClass sentiment;

        private SentimentDatum(String sentence, SentimentClass sentiment) {
            this.sentence = sentence;
            this.sentiment = sentiment;
        }

        CoreMap asCoreMap() {
            Annotation ann;
            block8: {
                block7: {
                    if (!"".equals(this.sentence.trim())) break block7;
                    switch (this.sentiment) {
                        case VERY_POSITIVE: {
                            ann = new Annotation("cats are super awesome!");
                            break block8;
                        }
                        case POSITIVE: {
                            ann = new Annotation("cats are great");
                            break block8;
                        }
                        case NEUTRAL: {
                            ann = new Annotation("cats have tails");
                            break block8;
                        }
                        case NEGATIVE: {
                            ann = new Annotation("cats suck");
                            break block8;
                        }
                        case VERY_NEGATIVE: {
                            ann = new Annotation("cats are literally the worst, I can't even.");
                            break block8;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                ann = new Annotation(this.sentence);
            }
            ((StanfordCoreNLP)pipeline.get()).annotate(ann);
            return (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        }
    }
}

