/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.sequences.BestSequenceFinderTest;
import edu.stanford.nlp.sequences.KBestSequenceFinder;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class KBestSequenceFinderTest
extends TestCase {
    private static final boolean DEBUG = false;
    private static final int K2NR = 20;
    private static String[] test2nrAnswers = new String[]{"[0, 0, 7, 8, 9]", "[0, 0, 6, 7, 8]", "[0, 0, 5, 6, 7]", "[0, 0, 4, 5, 6]", "[0, 0, 8, 9, 1]", "[0, 0, 1, 8, 9]", "[0, 0, 2, 8, 9]", "[0, 0, 8, 9, 2]", "[0, 0, 8, 9, 3]", "[0, 0, 3, 8, 9]", "[0, 0, 4, 8, 9]", "[0, 0, 8, 9, 4]", "[0, 0, 3, 4, 5]", "[0, 0, 8, 9, 5]", "[0, 0, 5, 8, 9]", "[0, 0, 6, 8, 9]", "[0, 0, 8, 9, 6]", "[0, 0, 8, 9, 7]", "[0, 0, 8, 8, 9]", "[0, 0, 8, 9, 8]"};
    private static double[] test2nrScores = new double[]{17.142857142857142, 15.166666666666668, 13.2, 11.25, 10.125, 10.125, 9.625, 9.625, 9.458333333333334, 9.458333333333334, 9.375, 9.375, 9.333333333333332, 9.325, 9.325, 9.291666666666666, 9.291666666666666, 9.267857142857142, 9.25, 9.25};

    public void testPerStateBestSequenceFinder() {
        KBestSequenceFinder bsf = new KBestSequenceFinder();
        BestSequenceFinderTest.TestSequenceModel2nr tsm2nr = new BestSequenceFinderTest.TestSequenceModel2nr();
        KBestSequenceFinderTest.runSequencesFinder(tsm2nr, bsf);
        BestSequenceFinderTest.runPossibleValuesChecker(tsm2nr, bsf);
    }

    public static void runSequencesFinder(BestSequenceFinderTest.TestSequenceModel tsm, KBestSequenceFinder sf) {
        Counter<int[]> bestLabelsCounter = sf.kBestSequences(tsm, 20);
        List<int[]> topValues = Counters.toSortedList(bestLabelsCounter);
        Iterator<int[]> iter = topValues.iterator();
        for (int i = 0; i < 20; ++i) {
            int[] sequence = iter.next();
            String strSequence = Arrays.toString(sequence);
            double score = bestLabelsCounter.getCount(sequence);
            boolean found = false;
            if (strSequence.equals(test2nrAnswers[i])) {
                found = true;
            } else if (i > 0 && Math.abs(score - test2nrScores[i - 1]) < 1.0E-8 && strSequence.equals(test2nrAnswers[i - 1])) {
                found = true;
            } else if (i + 1 < test2nrScores.length && Math.abs(score - test2nrScores[i + 1]) < 1.0E-8 && strSequence.equals(test2nrAnswers[i + 1])) {
                found = true;
            }
            KBestSequenceFinderTest.assertTrue((String)("Best sequence is wrong. Correct: " + test2nrAnswers[i] + ", found: " + strSequence), (boolean)found);
            KBestSequenceFinderTest.assertEquals((String)"Best sequence score is wrong.", (double)test2nrScores[i], (double)score, (double)1.0E-8);
        }
    }
}

