/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.DelimitRegExIterator;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class LibSVMReaderAndWriter
implements DocumentReaderAndWriter<CoreLabel> {
    private static Redwood.RedwoodChannels log = Redwood.channels(LibSVMReaderAndWriter.class);
    private static final long serialVersionUID = -7997837004847909059L;
    private SeqClassifierFlags flags = null;
    private IteratorFromReaderFactory factory;
    int num = 0;

    @Override
    public void init(SeqClassifierFlags flags) {
        this.flags = flags;
        this.factory = DelimitRegExIterator.getFactory("\n(\\s*\n)+", new ColumnDocParser());
    }

    @Override
    public Iterator<List<CoreLabel>> getIterator(Reader r) {
        return this.factory.getIterator(r);
    }

    @Override
    public void printAnswers(List<CoreLabel> doc, PrintWriter out2) {
        for (CoreLabel wi : doc) {
            String answer = (String)wi.get(CoreAnnotations.AnswerAnnotation.class);
            String goldAnswer = (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class);
            out2.println(goldAnswer + "\t" + answer);
        }
        out2.println();
    }

    private class ColumnDocParser
    implements Function<String, List<CoreLabel>> {
        private ColumnDocParser() {
        }

        @Override
        public List<CoreLabel> apply(String doc) {
            String[] lines;
            if (LibSVMReaderAndWriter.this.num % 1000 == 0) {
                log.info("[" + LibSVMReaderAndWriter.this.num + "]");
            }
            ++LibSVMReaderAndWriter.this.num;
            ArrayList<CoreLabel> words = new ArrayList<CoreLabel>();
            for (String line : lines = doc.split("\n")) {
                if (line.trim().length() < 1) continue;
                CoreLabel wi = new CoreLabel();
                String[] info = line.split("\\s+");
                wi.set(CoreAnnotations.AnswerAnnotation.class, info[0]);
                wi.set(CoreAnnotations.GoldAnswerAnnotation.class, info[0]);
                for (int j = 1; j < info.length; ++j) {
                    String[] stringArray = info[j].split(":");
                }
                words.add(wi);
            }
            return words;
        }
    }
}

