/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.objectbank.XMLBeginEndIterator;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MUCDocumentReaderAndWriter
implements DocumentReaderAndWriter<CoreLabel> {
    private static Redwood.RedwoodChannels log = Redwood.channels(MUCDocumentReaderAndWriter.class);
    private static final long serialVersionUID = -8334720781758500037L;
    private SeqClassifierFlags flags;
    private IteratorFromReaderFactory<List<CoreLabel>> factory;

    @Override
    public void init(SeqClassifierFlags flags) {
        this.flags = flags;
        this.factory = XMLBeginEndIterator.getFactory("DOC", new MUCDocumentParser(), true, true);
    }

    @Override
    public Iterator<List<CoreLabel>> getIterator(Reader r) {
        return this.factory.getIterator(r);
    }

    @Override
    public void printAnswers(List<CoreLabel> doc, PrintWriter pw) {
        String prevAnswer = "O";
        String prevClass = "";
        String afterLast = "";
        for (CoreLabel word : doc) {
            if (!prevAnswer.equals("O") && !prevAnswer.equals(word.get(CoreAnnotations.AnswerAnnotation.class))) {
                pw.print("</" + prevClass + ">");
                prevClass = "";
            }
            pw.print((String)word.get(CoreAnnotations.BeforeAnnotation.class));
            if (!((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equals("O") && !((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equals(prevAnswer)) {
                if (((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equalsIgnoreCase("PERSON") || ((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equalsIgnoreCase("ORGANIZATION") || ((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equalsIgnoreCase("LOCATION")) {
                    prevClass = "ENAMEX";
                } else if (((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equalsIgnoreCase("DATE") || ((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equalsIgnoreCase("TIME")) {
                    prevClass = "TIMEX";
                } else if (((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equalsIgnoreCase("PERCENT") || ((String)word.get(CoreAnnotations.AnswerAnnotation.class)).equalsIgnoreCase("MONEY")) {
                    prevClass = "NUMEX";
                } else {
                    log.info("unknown type: " + (String)word.get(CoreAnnotations.AnswerAnnotation.class));
                    System.exit(0);
                }
                pw.print("<" + prevClass + " TYPE=\"" + (String)word.get(CoreAnnotations.AnswerAnnotation.class) + "\">");
            }
            pw.print((String)word.get(CoreAnnotations.OriginalTextAnnotation.class));
            afterLast = (String)word.get(CoreAnnotations.AfterAnnotation.class);
            prevAnswer = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
        }
        if (!prevAnswer.equals("O")) {
            pw.print("</" + prevClass + ">");
            prevClass = "";
        }
        pw.println(afterLast);
    }

    static class MUCDocumentParser
    implements Function<String, List<CoreLabel>> {
        private static final Pattern sgml = Pattern.compile("<([^>\\s]*)[^>]*>");
        private static final Pattern beginEntity = Pattern.compile("<(ENAMEX|TIMEX|NUMEX) TYPE=\"([a-z]+)\"[^>]*>", 2);
        private static final Pattern endEntity = Pattern.compile("</(ENAMEX|TIMEX|NUMEX)>");

        MUCDocumentParser() {
        }

        @Override
        public List<CoreLabel> apply(String doc) {
            if (doc == null) {
                return null;
            }
            String section = "";
            String entity = "O";
            String entityClass = "";
            int pNum = 0;
            int sNum = 0;
            int wNum = 0;
            PTBTokenizer<CoreLabel> ptb = PTBTokenizer.newPTBTokenizer(new BufferedReader(new StringReader(doc)), false, true);
            List words = ptb.tokenize();
            ArrayList<CoreLabel> result = new ArrayList<CoreLabel>();
            ArrayCoreMap prev = null;
            String prevString = "";
            for (CoreLabel word : words) {
                Matcher matcher = sgml.matcher(word.word());
                if (matcher.matches()) {
                    String s;
                    String tag = matcher.group(1);
                    if (word.word().equalsIgnoreCase("<p>")) {
                        ++pNum;
                        sNum = 0;
                        wNum = 0;
                        if (prev != null) {
                            s = (String)prev.get(CoreAnnotations.AfterAnnotation.class);
                            s = s + word.originalText() + word.after();
                            prev.set(CoreAnnotations.AfterAnnotation.class, s);
                        }
                        prevString = prevString + word.before() + word.originalText();
                        continue;
                    }
                    if (word.word().equalsIgnoreCase("<s>")) {
                        ++sNum;
                        wNum = 0;
                        if (prev != null) {
                            s = (String)prev.get(CoreAnnotations.AfterAnnotation.class);
                            s = s + word.originalText() + word.after();
                            prev.set(CoreAnnotations.AfterAnnotation.class, s);
                        }
                        prevString = prevString + word.before() + word.originalText();
                        continue;
                    }
                    matcher = beginEntity.matcher(word.word());
                    if (matcher.matches()) {
                        entityClass = matcher.group(1);
                        entity = matcher.group(2);
                        if (prev != null) {
                            s = (String)prev.get(CoreAnnotations.AfterAnnotation.class);
                            s = s + word.after();
                            prev.set(CoreAnnotations.AfterAnnotation.class, s);
                        }
                        prevString = prevString + word.before();
                        continue;
                    }
                    matcher = endEntity.matcher(word.word());
                    if (matcher.matches()) {
                        entityClass = "";
                        entity = "O";
                        if (prev != null) {
                            s = (String)prev.get(CoreAnnotations.AfterAnnotation.class);
                            s = s + word.after();
                            prev.set(CoreAnnotations.AfterAnnotation.class, s);
                        }
                        prevString = prevString + word.before();
                        continue;
                    }
                    if (word.word().equalsIgnoreCase("<doc>")) {
                        prevString = prevString + word.before() + word.originalText();
                        continue;
                    }
                    if (word.word().equalsIgnoreCase("</doc>")) {
                        s = (String)prev.get(CoreAnnotations.AfterAnnotation.class);
                        s = s + word.originalText();
                        prev.set(CoreAnnotations.AfterAnnotation.class, s);
                        continue;
                    }
                    section = tag.toUpperCase();
                    if (prev != null) {
                        s = (String)prev.get(CoreAnnotations.AfterAnnotation.class);
                        s = s + word.originalText() + word.after();
                        prev.set(CoreAnnotations.AfterAnnotation.class, s);
                    }
                    prevString = prevString + word.before() + word.originalText();
                    continue;
                }
                CoreLabel wi = new CoreLabel();
                wi.setWord(word.word());
                wi.set(CoreAnnotations.OriginalTextAnnotation.class, word.originalText());
                wi.set(CoreAnnotations.BeforeAnnotation.class, prevString + word.before());
                wi.set(CoreAnnotations.AfterAnnotation.class, word.after());
                wi.set(CoreAnnotations.WordPositionAnnotation.class, "" + wNum);
                wi.set(CoreAnnotations.SentencePositionAnnotation.class, "" + sNum);
                wi.set(CoreAnnotations.ParaPositionAnnotation.class, "" + pNum);
                wi.set(CoreAnnotations.SectionAnnotation.class, section);
                wi.set(CoreAnnotations.AnswerAnnotation.class, entity);
                wi.set(CoreAnnotations.EntityClassAnnotation.class, entityClass);
                ++wNum;
                prevString = "";
                result.add(wi);
                prev = wi;
            }
            return result;
        }
    }
}

