/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.DelimitRegExIterator;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class MalletReaderAndWriter
implements DocumentReaderAndWriter<CoreLabel> {
    private static Redwood.RedwoodChannels log = Redwood.channels(MalletReaderAndWriter.class);
    private static final long serialVersionUID = 3806263423691913704L;
    private SeqClassifierFlags flags = null;
    private String[] map = null;
    private IteratorFromReaderFactory factory;
    int num = 0;

    @Override
    public void init(SeqClassifierFlags flags) {
        this.flags = flags;
        this.map = StringUtils.mapStringToArray(flags.map);
        this.factory = DelimitRegExIterator.getFactory("\n(\\s*\n)+", new MalletDocParser());
    }

    @Override
    public Iterator<List<CoreLabel>> getIterator(Reader r) {
        return this.factory.getIterator(r);
    }

    @Override
    public void printAnswers(List<CoreLabel> doc, PrintWriter out2) {
        for (CoreLabel wi : doc) {
            String answer = (String)wi.get(CoreAnnotations.AnswerAnnotation.class);
            String goldAnswer = (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class);
            out2.println(wi.word() + "\t" + goldAnswer + "\t" + answer);
        }
        out2.println();
    }

    private class MalletDocParser
    implements Serializable,
    Function<String, List<CoreLabel>> {
        private static final long serialVersionUID = -6211332661459630572L;

        private MalletDocParser() {
        }

        @Override
        public List<CoreLabel> apply(String doc) {
            String[] lines;
            if (MalletReaderAndWriter.this.num % 1000 == 0) {
                log.info("[" + MalletReaderAndWriter.this.num + "]");
            }
            ++MalletReaderAndWriter.this.num;
            ArrayList<CoreLabel> words = new ArrayList<CoreLabel>();
            for (String line : lines = doc.split("\n")) {
                if (line.trim().length() < 1) continue;
                int idx = line.lastIndexOf(" ");
                if (idx < 0) {
                    throw new RuntimeException("Bad line: " + line);
                }
                CoreLabel wi = new CoreLabel();
                wi.setWord(line.substring(0, idx));
                wi.set(CoreAnnotations.AnswerAnnotation.class, line.substring(idx + 1));
                wi.set(CoreAnnotations.GoldAnswerAnnotation.class, line.substring(idx + 1));
                words.add(wi);
            }
            return words;
        }
    }
}

