/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.ArabicDocument;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class ArabicSentence
extends Sentence {
    static Properties SINGLE_SENTENCE_DOCUMENT = new Properties(){
        {
            try {
                this.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-arabic.properties"));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "arabic");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "ar");
        }
    };
    private static Properties SINGLE_SENTENCE_TOKENIZED_DOCUMENT = new Properties(){
        {
            try {
                this.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-arabic.properties"));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "arabic");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "WhitespaceTokenizer");
            this.setProperty("tokenize.language", "ar");
            this.setProperty("tokenize.whitespace", "true");
        }
    };

    public ArabicSentence(String text) {
        super((Document)new ArabicDocument(text), SINGLE_SENTENCE_DOCUMENT);
    }

    public ArabicSentence(List<String> tokens) {
        super(ArabicDocument::new, tokens, SINGLE_SENTENCE_TOKENIZED_DOCUMENT);
    }

    public ArabicSentence(CoreNLPProtos.Sentence proto) {
        super(ArabicDocument::new, proto, SINGLE_SENTENCE_DOCUMENT);
    }
}

