/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.FrenchDocument;
import edu.stanford.nlp.simple.Sentence;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class FrenchSentence
extends Sentence {
    static Properties SINGLE_SENTENCE_DOCUMENT = new Properties(){
        {
            try {
                this.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-french.properties"));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "french");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "fr");
        }
    };
    private static Properties SINGLE_SENTENCE_TOKENIZED_DOCUMENT = new Properties(){
        {
            try {
                this.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-french.properties"));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "french");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "WhitespaceTokenizer");
            this.setProperty("tokenize.language", "fr");
            this.setProperty("tokenize.whitespace", "true");
        }
    };

    public FrenchSentence(String text) {
        super((Document)new FrenchDocument(text), SINGLE_SENTENCE_DOCUMENT);
    }

    public FrenchSentence(List<String> tokens) {
        super(FrenchDocument::new, tokens, SINGLE_SENTENCE_TOKENIZED_DOCUMENT);
    }

    public FrenchSentence(CoreNLPProtos.Sentence proto) {
        super(FrenchDocument::new, proto, SINGLE_SENTENCE_DOCUMENT);
    }
}

