/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.simple.Sentence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class SentenceAlgorithmsITest {
    @Test
    public void testKeyphrases() throws IOException {
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 1));
                this.add(new Span(2, 3));
            }
        }, new Sentence("cats and dogs.").algorithms().keyphraseSpans());
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 1));
                this.add(new Span(1, 2));
                this.add(new Span(3, 4));
            }
        }, new Sentence("cats playing with dogs.").algorithms().keyphraseSpans());
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 2));
                this.add(new Span(3, 4));
            }
        }, new Sentence("black cats are furry.").algorithms().keyphraseSpans());
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 1));
                this.add(new Span(1, 3));
                this.add(new Span(3, 4));
                this.add(new Span(6, 8));
                this.add(new Span(10, 12));
                this.add(new Span(13, 14));
                this.add(new Span(17, 20));
            }
        }, new Sentence("Freezing involves changing water from its liquid state to its solid state (ice) by the removal of heat.").algorithms().keyphraseSpans());
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 1));
                this.add(new Span(1, 2));
                this.add(new Span(4, 5));
                this.add(new Span(7, 8));
                this.add(new Span(8, 9));
                this.add(new Span(11, 12));
            }
        }, new Sentence("Water freezing is an example of a liquid changing to a solid.").algorithms().keyphraseSpans());
    }

    @Test
    public void testKeyphrasesPP() throws IOException {
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 3));
            }
        }, new Sentence("period of daylight.").algorithms().keyphraseSpans());
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 1));
                this.add(new Span(3, 4));
            }
        }, new Sentence("frequency of the wave.").algorithms().keyphraseSpans());
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 1));
            }
        }, new Sentence("period of.").algorithms().keyphraseSpans());
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 2));
                this.add(new Span(4, 5));
            }
        }, new Sentence("Barack Obama of the USA.").algorithms().keyphraseSpans());
    }

    @Test
    public void testKeyphrasesRegressions() throws IOException {
        Assert.assertEquals((Object)new ArrayList<Span>(){
            {
                this.add(new Span(0, 1));
                this.add(new Span(3, 4));
                this.add(new Span(5, 6));
                this.add(new Span(7, 10));
            }
        }, new Sentence("meters can be used to describe an object's length").algorithms().keyphraseSpans());
    }

    @Test
    public void testKeyphrasesAsString() throws IOException {
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("Water");
                this.add("freezing");
                this.add("example");
                this.add("liquid");
                this.add("changing");
                this.add("solid");
            }
        }, new Sentence("Water freezing is an example of a liquid changing to a solid.").algorithms().keyphrases());
    }

    @Test
    public void testHeadOfSpan() throws IOException {
        Sentence s = new Sentence("Freezing involves changing water from its liquid state to its solid state (ice) by the removal of heat.");
        Assert.assertEquals((long)1L, (long)s.algorithms().headOfSpan(new Span(0, 3)));
        Assert.assertEquals((long)7L, (long)s.algorithms().headOfSpan(new Span(5, 8)));
        Assert.assertEquals((long)2L, (long)s.algorithms().headOfSpan(new Span(2, 8)));
    }

    @Test
    public void testAllSpans() throws IOException {
        Sentence s = new Sentence("a b c d");
        Iterator iter = s.algorithms().allSpans(Sentence::words).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
                this.add("b");
                this.add("c");
                this.add("d");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
                this.add("b");
                this.add("c");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("b");
                this.add("c");
                this.add("d");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
                this.add("b");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("b");
                this.add("c");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("c");
                this.add("d");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("b");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("c");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("d");
            }
        }, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testAllSpansLimited() throws IOException {
        Sentence s = new Sentence("a b c d");
        Iterator iter = s.algorithms().allSpans(Sentence::words, 2).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
                this.add("b");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("b");
                this.add("c");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("c");
                this.add("d");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("b");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("c");
            }
        }, iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("d");
            }
        }, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testDependencyPathBetween() throws IOException {
        Sentence s = new Sentence("the blue cat sat on the green mat");
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("the");
                this.add("<-det-");
                this.add("cat");
            }
        }, s.algorithms().dependencyPathBetween(0, 2));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("the");
                this.add("<-det-");
                this.add("cat");
                this.add("-amod->");
                this.add("blue");
            }
        }, s.algorithms().dependencyPathBetween(0, 1));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("the");
                this.add("<-det-");
                this.add("mat");
                this.add("-amod->");
                this.add("green");
            }
        }, s.algorithms().dependencyPathBetween(5, 6));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("the");
                this.add("<-det-");
                this.add("cat");
            }
        }, s.algorithms().dependencyPathBetween(0, 2));
        s = new Sentence("I visited River Road Asset Management of Louisville , Kentucky .");
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("Management");
                this.add("-nmod:of->");
                this.add("Louisville");
                this.add("-appos->");
                this.add("Kentucky");
            }
        }, s.algorithms().dependencyPathBetween(5, 9));
    }

    @Test
    public void testLoopyDependencyPathBetween() throws IOException {
        Sentence s = new Sentence("the blue cat sat on the green mat");
        for (int start = 0; start < s.length(); ++start) {
            for (int end = 0; end < s.length(); ++end) {
                Assert.assertEquals(s.algorithms().dependencyPathBetween(start, end, Optional.of(Sentence::words)), s.algorithms().loopyDependencyPathBetween(start, end, Optional.of(Sentence::words)));
            }
        }
    }

    @Test
    public void testDependencyPathBetweenRegressions() throws IOException {
        Sentence s = new Sentence("In the Middle Ages, several powerful Somali empires dominated the regional trade including the Ajuran Sultanate, which excelled in hydraulic engineering and fortress building, the Sultanate of Adal, whose general Ahmad ibn Ibrahim al-Ghazi (Ahmed Gurey) was the first commander to use cannon warfare on the continent during Adal's conquest of the Ethiopian Empire, and the Sultanate of the Geledi, whose military dominance forced governors of the Omani empire north of the city of Lamu to pay tribute to the Somali Sultan Ahmed Yusuf.");
        s.dependencyGraph();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("forced");
                this.add("<-acl:relcl-");
                this.add("Geledi");
                this.add("<-nmod:of-");
                this.add("Sultanate");
                this.add("<-conj:and-");
                this.add("Sultanate");
                this.add("<-nmod:including-");
                this.add("trade");
                this.add("<-dobj-");
                this.add("dominated");
                this.add("-nmod:in->");
                this.add("Ages");
                this.add("-compound->");
                this.add("Middle");
            }
        }, s.algorithms().dependencyPathBetween(72, 2));
    }
}

