/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.Operator;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class SentenceITest {
    @Test
    public void testPOSTag() {
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("DT");
                this.add("NN");
                this.add("VBZ");
                this.add("JJ");
                this.add(".");
            }
        }, new Sentence("The cat is blue.").posTags());
    }

    @Test
    public void testLemma() {
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("the");
                this.add("cat");
                this.add("be");
                this.add("blue");
                this.add(".");
            }
        }, new Sentence("The cats are blue.").lemmas());
    }

    @Test
    public void testNER() {
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("PERSON");
                this.add("PERSON");
                this.add("O");
                this.add("O");
                this.add("O");
                this.add("LOCATION");
                this.add("LOCATION");
                this.add("O");
            }
        }, new Sentence("George Bush lives in the United States.").nerTags());
    }

    @Test
    public void testMentions() {
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("George Bush");
            }
        }, new Sentence("George Bush lives in the United States.").mentions("PERSON"));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("George Bush");
                this.add("Bill Clinton");
            }
        }, new Sentence("George Bush and Bill Clinton").mentions("PERSON"));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("George Bush");
                this.add("United States");
            }
        }, new Sentence("George Bush lives in the United States.").mentions());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("George Bush");
                this.add("Bill Clinton");
            }
        }, new Sentence("George Bush and Bill Clinton").mentions());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("George Bush");
                this.add("27");
            }
        }, new Sentence("George Bush 27").mentions());
    }

    @Test
    public void testParse() {
        Assert.assertEquals((Object)"(ROOT (S (NP (DT The) (NN cat)) (VP (VBZ is) (ADJP (JJ blue))) (. .)))", (Object)new Sentence("The cat is blue.").parse().pennString().replaceAll("\n", " ").replaceAll("\\s+", " ").trim());
    }

    @Test
    public void testNatlogOperators() {
        Sentence sentence = new Sentence("All cats have tails.");
        List<Optional<OperatorSpec>> operators = sentence.operators();
        Assert.assertTrue((boolean)operators.get(0).isPresent());
        Assert.assertTrue((boolean)sentence.operatorAt(0).isPresent());
        Assert.assertFalse((boolean)operators.get(1).isPresent());
        Assert.assertFalse((boolean)sentence.operatorAt(1).isPresent());
        Assert.assertEquals((long)1L, (long)sentence.operatorsNonempty().size());
        Assert.assertEquals((Object)((Object)Operator.ALL), (Object)((Object)sentence.operatorsNonempty().get((int)0).instance));
    }

    @Test
    public void testNatlogPolarities() {
        Sentence sentence = new Sentence("All cats have tails.");
        List<Polarity> polarities = sentence.natlogPolarities();
        Assert.assertTrue((boolean)polarities.get(0).isUpwards());
        Assert.assertTrue((boolean)polarities.get(1).isDownwards());
        Assert.assertTrue((boolean)polarities.get(2).isUpwards());
        Assert.assertTrue((boolean)polarities.get(3).isUpwards());
        Assert.assertTrue((boolean)polarities.get(4).isUpwards());
        Assert.assertTrue((boolean)sentence.natlogPolarity(0).isUpwards());
        Assert.assertTrue((boolean)sentence.natlogPolarity(1).isDownwards());
        Assert.assertTrue((boolean)sentence.natlogPolarity(2).isUpwards());
        Assert.assertTrue((boolean)sentence.natlogPolarity(3).isUpwards());
        Assert.assertTrue((boolean)sentence.natlogPolarity(4).isUpwards());
    }

    @Test
    public void testDependencyParse() {
        Sentence sentence = new Sentence("The cat is blue.");
        Assert.assertEquals((Object)new Integer(1), (Object)sentence.governor(0).orElse(-42));
        Assert.assertEquals((Object)new Integer(3), (Object)sentence.governor(1).orElse(-42));
        Assert.assertEquals((Object)new Integer(3), (Object)sentence.governor(2).orElse(-42));
        Assert.assertEquals((Object)new Integer(-1), (Object)sentence.governor(3).orElse(-42));
        Assert.assertEquals((Object)new Integer(3), (Object)sentence.governor(4).orElse(-42));
        Assert.assertEquals((Object)"det", (Object)sentence.incomingDependencyLabel(0).orElse("???"));
        Assert.assertEquals((Object)"nsubj", (Object)sentence.incomingDependencyLabel(1).orElse("???"));
        Assert.assertEquals((Object)"cop", (Object)sentence.incomingDependencyLabel(2).orElse("???"));
        Assert.assertEquals((Object)"root", (Object)sentence.incomingDependencyLabel(3).orElse("???"));
        Assert.assertEquals((Object)"punct", (Object)sentence.incomingDependencyLabel(4).orElse("???"));
        Assert.assertNotNull(sentence.asCoreMap(new Function[0]).get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
        Assert.assertNotNull(sentence.asCoreMap(new Function[0]).get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        Assert.assertNotNull(sentence.asCoreMap(new Function[0]).get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class));
        Assert.assertNull(sentence.asCoreMap(new Function[0]).get(TreeCoreAnnotations.TreeAnnotation.class));
        for (int i = 0; i < sentence.length(); ++i) {
            Assert.assertEquals(sentence.governor(i), sentence.governors().get(i));
            Assert.assertEquals(sentence.incomingDependencyLabel(i), sentence.incomingDependencyLabels().get(i));
        }
    }

    @Test
    public void testDependencyParseWithParseAnnotator() {
        Sentence sentence = new Sentence("The cat is blue.");
        sentence.parse();
        Assert.assertEquals((Object)new Integer(1), (Object)sentence.governor(0).orElse(-42));
        Assert.assertEquals((Object)new Integer(3), (Object)sentence.governor(1).orElse(-42));
        Assert.assertEquals((Object)new Integer(3), (Object)sentence.governor(2).orElse(-42));
        Assert.assertEquals((Object)new Integer(-1), (Object)sentence.governor(3).orElse(-42));
        Assert.assertEquals((Object)"det", (Object)sentence.incomingDependencyLabel(0).orElse("???"));
        Assert.assertEquals((Object)"nsubj", (Object)sentence.incomingDependencyLabel(1).orElse("???"));
        Assert.assertEquals((Object)"cop", (Object)sentence.incomingDependencyLabel(2).orElse("???"));
        Assert.assertEquals((Object)"root", (Object)sentence.incomingDependencyLabel(3).orElse("???"));
        Assert.assertNotNull(sentence.asCoreMap(new Function[0]).get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
        Assert.assertNotNull(sentence.asCoreMap(new Function[0]).get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        Assert.assertNotNull(sentence.asCoreMap(new Function[0]).get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class));
        Assert.assertNotNull(sentence.asCoreMap(new Function[0]).get(TreeCoreAnnotations.TreeAnnotation.class));
        for (int i = 0; i < sentence.length(); ++i) {
            Assert.assertEquals(sentence.governor(i), sentence.governors().get(i));
            Assert.assertEquals(sentence.incomingDependencyLabel(i), sentence.incomingDependencyLabels().get(i));
        }
    }

    @Test
    public void testToCoreLabels() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog");
        List<CoreLabel> tokens = sent.asCoreLabels(Sentence::posTags);
        Assert.assertEquals((long)9L, (long)tokens.size());
        Assert.assertEquals((Object)"the", (Object)tokens.get(0).word());
        Assert.assertEquals((Object)"dog", (Object)tokens.get(8).word());
        Assert.assertEquals((Object)"DT", (Object)tokens.get(0).tag());
        Assert.assertEquals((Object)"NN", (Object)tokens.get(8).tag());
    }

    @Test
    public void testWriteRead() throws IOException {
        File tmp = File.createTempFile("sentenceITest", ".ser");
        tmp.deleteOnExit();
        FileOutputStream out2 = new FileOutputStream(tmp);
        Sentence orig = new Sentence("Cats have tails");
        orig.serialize(out2);
        out2.close();
        FileInputStream in = new FileInputStream(tmp);
        Sentence loaded = Sentence.deserialize(in);
        Assert.assertEquals((Object)orig, (Object)loaded);
        ((InputStream)in).close();
    }
}

