/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class SentenceTest {
    @Test
    public void testCreateFromText() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog");
        Assert.assertNotNull((Object)sent);
    }

    @Test
    public void testText() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog");
        Assert.assertEquals((Object)"the quick brown fox jumped over the lazy dog", (Object)sent.text());
    }

    @Test
    public void testLength() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog");
        Assert.assertEquals((long)9L, (long)sent.length());
    }

    @Test
    public void testDocumentLinking() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog");
        Assert.assertEquals((Object)sent, (Object)sent.document.sentence(0));
    }

    @Test
    public void testBasicTokenization() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog.");
        Assert.assertEquals((Object)"the", (Object)sent.word(0));
        Assert.assertEquals((Object)"quick", (Object)sent.word(1));
        Assert.assertEquals((Object)"dog", (Object)sent.word(8));
        Assert.assertEquals((Object)".", (Object)sent.word(9));
    }

    @Test
    public void testWeirdTokens() {
        Sentence sent = new Sentence("United States of America (USA) it's a country.");
        Assert.assertEquals((Object)"-LRB-", (Object)sent.word(4));
        Assert.assertEquals((Object)"-RRB-", (Object)sent.word(6));
        Assert.assertEquals((Object)"'s", (Object)sent.word(8));
    }

    @Test
    public void testOriginalText() {
        Sentence sent = new Sentence("United States of America (USA) it's a country.");
        Assert.assertEquals((Object)"(", (Object)sent.originalText(4));
        Assert.assertEquals((Object)")", (Object)sent.originalText(6));
        Assert.assertEquals((Object)"it", (Object)sent.originalText(7));
        Assert.assertEquals((Object)"'s", (Object)sent.originalText(8));
    }

    @Test
    public void testCharacterOffsets() {
        Sentence sent = new Sentence("United States of America (USA) it's a country.");
        Assert.assertEquals((long)0L, (long)sent.characterOffsetBegin(0));
        Assert.assertEquals((long)6L, (long)sent.characterOffsetEnd(0));
        Assert.assertEquals((long)7L, (long)sent.characterOffsetBegin(1));
        Assert.assertEquals((long)25L, (long)sent.characterOffsetBegin(4));
        Assert.assertEquals((long)26L, (long)sent.characterOffsetEnd(4));
    }

    @Test
    public void testSentenceIndex() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog");
        Assert.assertEquals((long)0L, (long)sent.sentenceIndex());
        Document doc = new Document("the quick brown fox jumped over the lazy dog. The lazy dog was not impressed.");
        List<Sentence> sentences = doc.sentences();
        Assert.assertEquals((long)0L, (long)sentences.get(0).sentenceIndex());
        Assert.assertEquals((long)1L, (long)sentences.get(1).sentenceIndex());
    }

    @Test
    public void testSentenceTokenOffsets() {
        Sentence sent = new Sentence("the quick brown fox jumped over the lazy dog");
        Assert.assertEquals((long)0L, (long)sent.sentenceTokenOffsetBegin());
        Document doc = new Document("the quick brown fox jumped over the lazy dog. The lazy dog was not impressed.");
        List<Sentence> sentences = doc.sentences();
        Assert.assertEquals((long)0L, (long)sentences.get(0).sentenceTokenOffsetBegin());
        Assert.assertEquals((long)10L, (long)sentences.get(0).sentenceTokenOffsetEnd());
        Assert.assertEquals((long)10L, (long)sentences.get(1).sentenceTokenOffsetBegin());
        Assert.assertEquals((long)17L, (long)sentences.get(1).sentenceTokenOffsetEnd());
    }

    @Test
    public void testFromCoreMapCrashCheck() {
        StanfordCoreNLP pipeline = new StanfordCoreNLP(new Properties(){
            {
                this.setProperty("annotators", "tokenize,ssplit");
            }
        });
        Annotation ann = new Annotation("This is a sentence.");
        pipeline.annotate(ann);
        CoreMap map = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        new Sentence(map);
    }

    @Test
    public void testFromCoreMapCorrectnessCheck() {
        StanfordCoreNLP pipeline = new StanfordCoreNLP(new Properties(){
            {
                this.setProperty("annotators", "tokenize,ssplit");
            }
        });
        Annotation ann = new Annotation("This is a sentence.");
        pipeline.annotate(ann);
        CoreMap map = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        Sentence s = new Sentence(map);
        Assert.assertEquals(ann.get(CoreAnnotations.TextAnnotation.class), (Object)s.text());
        Assert.assertEquals((Object)"This", (Object)s.word(0));
        Assert.assertEquals((long)5L, (long)s.length());
    }

    @Test
    public void testTokenizeWhitespaceSimple() {
        Sentence s = new Sentence((List<String>)new ArrayList<String>(){
            {
                this.add("foo");
                this.add("bar");
            }
        });
        Assert.assertEquals((Object)"foo", (Object)s.word(0));
        Assert.assertEquals((Object)"bar", (Object)s.word(1));
    }

    @Test
    public void testTokenizeWhitespaceWithSpaces() {
        Sentence s = new Sentence((List<String>)new ArrayList<String>(){
            {
                this.add("foo");
                this.add("with whitespace");
                this.add("baz");
            }
        });
        Assert.assertEquals((Object)"foo", (Object)s.word(0));
        Assert.assertEquals((Object)"with whitespace", (Object)s.word(1));
        Assert.assertEquals((Object)"baz", (Object)s.word(2));
    }
}

