/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.simple.SpanishDocument;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class SpanishSentence
extends Sentence {
    static Properties SINGLE_SENTENCE_DOCUMENT = new Properties(){
        {
            try {
                this.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-spanish.properties"));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "spanish");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "es");
        }
    };
    private static Properties SINGLE_SENTENCE_TOKENIZED_DOCUMENT = new Properties(){
        {
            try {
                this.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-spanish.properties"));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "spanish");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "WhitespaceTokenizer");
            this.setProperty("tokenize.language", "es");
            this.setProperty("tokenize.whitespace", "true");
        }
    };

    public SpanishSentence(String text) {
        super((Document)new SpanishDocument(text), SINGLE_SENTENCE_DOCUMENT);
    }

    public SpanishSentence(List<String> tokens) {
        super(SpanishDocument::new, tokens, SINGLE_SENTENCE_TOKENIZED_DOCUMENT);
    }

    public SpanishSentence(CoreNLPProtos.Sentence proto) {
        super(SpanishDocument::new, proto, SINGLE_SENTENCE_DOCUMENT);
    }
}

