/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.Factory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;

public abstract class CounterTestBase
extends TestCase {
    private Counter<String> c;
    private final boolean integral;
    private static final double TOLERANCE = 0.001;

    public CounterTestBase(Counter<String> c) {
        this(c, false);
    }

    public CounterTestBase(Counter<String> c, boolean integral) {
        this.c = c;
        this.integral = integral;
    }

    public void setUp() {
        this.c.clear();
    }

    public void testClassicCounterHistoricalMain() {
        this.c.setCount("p", 0.0);
        this.c.setCount("q", 2.0);
        ClassicCounter<String> small_c = new ClassicCounter<String>(this.c);
        Counter<String> c7 = this.c.getFactory().create();
        c7.addAll(this.c);
        CounterTestBase.assertEquals((Object)this.c.totalCount(), (Object)2.0);
        this.c.incrementCount("p");
        CounterTestBase.assertEquals((Object)this.c.totalCount(), (Object)3.0);
        this.c.incrementCount("p", 2.0);
        CounterTestBase.assertEquals((Object)Counters.min(this.c), (Object)2.0);
        CounterTestBase.assertEquals((String)Counters.argmin(this.c), (String)"q");
        this.c.setCount("w", -5.0);
        this.c.setCount("x", -4.5);
        ArrayList<String> biggestKeys = new ArrayList<String>(this.c.keySet());
        CounterTestBase.assertEquals((int)biggestKeys.size(), (int)4);
        Collections.sort(biggestKeys, Counters.toComparator(this.c, false, true));
        CounterTestBase.assertEquals((String)"w", (String)((String)biggestKeys.get(0)));
        CounterTestBase.assertEquals((String)"x", (String)((String)biggestKeys.get(1)));
        CounterTestBase.assertEquals((String)"p", (String)((String)biggestKeys.get(2)));
        CounterTestBase.assertEquals((String)"q", (String)((String)biggestKeys.get(3)));
        CounterTestBase.assertEquals((double)Counters.min(this.c), (double)-5.0, (double)0.001);
        CounterTestBase.assertEquals((String)Counters.argmin(this.c), (String)"w");
        CounterTestBase.assertEquals((double)Counters.max(this.c), (double)3.0, (double)0.001);
        CounterTestBase.assertEquals((String)Counters.argmax(this.c), (String)"p");
        if (this.integral) {
            CounterTestBase.assertEquals((Object)Counters.mean(this.c), (Object)-1.0);
        } else {
            CounterTestBase.assertEquals((double)Counters.mean(this.c), (double)-1.125, (double)0.001);
        }
        if (!this.integral) {
            this.c.setCount("x", -2.5);
            ClassicCounter<String> c2 = new ClassicCounter<String>(this.c);
            CounterTestBase.assertEquals((Object)3.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)2.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)-5.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)-2.5, (Object)c2.getCount("x"));
            Counter<String> c3 = this.c.getFactory().create();
            for (String str : c2.keySet()) {
                c3.incrementCount(str);
            }
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("p"));
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("q"));
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("w"));
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("x"));
            Counters.addInPlace(c2, c3, 10.0);
            CounterTestBase.assertEquals((Object)13.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)12.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)5.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)7.5, (Object)c2.getCount("x"));
            c3.addAll(this.c);
            CounterTestBase.assertEquals((Object)4.0, (Object)c3.getCount("p"));
            CounterTestBase.assertEquals((Object)3.0, (Object)c3.getCount("q"));
            CounterTestBase.assertEquals((Object)-4.0, (Object)c3.getCount("w"));
            CounterTestBase.assertEquals((Object)-1.5, (Object)c3.getCount("x"));
            Counters.subtractInPlace(c3, this.c);
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("p"));
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("q"));
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("w"));
            CounterTestBase.assertEquals((Object)1.0, (Object)c3.getCount("x"));
            for (String str : this.c.keySet()) {
                c3.incrementCount(str);
            }
            CounterTestBase.assertEquals((Object)2.0, (Object)c3.getCount("p"));
            CounterTestBase.assertEquals((Object)2.0, (Object)c3.getCount("q"));
            CounterTestBase.assertEquals((Object)2.0, (Object)c3.getCount("w"));
            CounterTestBase.assertEquals((Object)2.0, (Object)c3.getCount("x"));
            Counters.divideInPlace(c2, c3);
            CounterTestBase.assertEquals((Object)6.5, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)6.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)2.5, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)3.75, (Object)c2.getCount("x"));
            Counters.divideInPlace(c2, 0.5);
            CounterTestBase.assertEquals((Object)13.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)12.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)5.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)7.5, (Object)c2.getCount("x"));
            Counters.multiplyInPlace(c2, 2.0);
            CounterTestBase.assertEquals((Object)26.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)24.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)10.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)15.0, (Object)c2.getCount("x"));
            Counters.divideInPlace(c2, 2.0);
            CounterTestBase.assertEquals((Object)13.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)12.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)5.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)7.5, (Object)c2.getCount("x"));
            for (String str : c2.keySet()) {
                c2.incrementCount(str);
            }
            CounterTestBase.assertEquals((Object)14.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)13.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)6.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)8.5, (Object)c2.getCount("x"));
            for (String str : this.c.keySet()) {
                c2.incrementCount(str);
            }
            CounterTestBase.assertEquals((Object)15.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)14.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)7.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)9.5, (Object)c2.getCount("x"));
            c2.addAll(small_c);
            CounterTestBase.assertEquals((Object)15.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)16.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)7.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)9.5, (Object)c2.getCount("x"));
            CounterTestBase.assertEquals(new HashSet<String>(Arrays.asList("p", "q")), Counters.keysAbove(c2, 14.0));
            CounterTestBase.assertEquals(new HashSet<String>(Arrays.asList("q")), Counters.keysAt(c2, 16.0));
            CounterTestBase.assertEquals(new HashSet<String>(Arrays.asList("x", "w")), Counters.keysBelow(c2, 9.5));
            Counters.addInPlace(c2, small_c, -6.0);
            CounterTestBase.assertEquals((Object)15.0, (Object)c2.getCount("p"));
            CounterTestBase.assertEquals((Object)4.0, (Object)c2.getCount("q"));
            CounterTestBase.assertEquals((Object)7.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)9.5, (Object)c2.getCount("x"));
            Counters.subtractInPlace(c2, small_c);
            Counters.subtractInPlace(c2, small_c);
            Counters.retainNonZeros(c2);
            CounterTestBase.assertEquals((Object)15.0, (Object)c2.getCount("p"));
            CounterTestBase.assertFalse((boolean)c2.containsKey("q"));
            CounterTestBase.assertEquals((Object)7.0, (Object)c2.getCount("w"));
            CounterTestBase.assertEquals((Object)9.5, (Object)c2.getCount("x"));
        }
        if (this.c instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream out2 = new ObjectOutputStream(new BufferedOutputStream(baos));
                out2.writeObject(this.c);
                out2.close();
                byte[] bytes = baos.toByteArray();
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(bytes)));
                this.c = (Counter)IOUtils.readObjectFromObjectStream(in);
                in.close();
                if (!this.integral) {
                    CounterTestBase.assertEquals((Object)-2.5, (Object)this.c.totalCount());
                    CounterTestBase.assertEquals((Object)-5.0, (Object)Counters.min(this.c));
                    CounterTestBase.assertEquals((String)"w", (String)Counters.argmin(this.c));
                }
                this.c.clear();
                if (!this.integral) {
                    CounterTestBase.assertEquals((Object)0.0, (Object)this.c.totalCount());
                }
            }
            catch (IOException ioe) {
                CounterTestBase.fail((String)("IOException: " + ioe));
            }
            catch (ClassNotFoundException cce) {
                CounterTestBase.fail((String)("ClassNotFoundException: " + cce));
            }
        }
    }

    public void testFactory() {
        Factory<Counter<String>> fcs = this.c.getFactory();
        Counter<String> c2 = fcs.create();
        c2.incrementCount("fr");
        c2.incrementCount("de");
        c2.incrementCount("es", -3.0);
        Counter<String> c3 = fcs.create();
        c3.decrementCount("es");
        Counter<String> c4 = fcs.create();
        c4.incrementCount("fr");
        c4.setCount("es", -3.0);
        c4.setCount("de", 1.0);
        CounterTestBase.assertEquals((String)"Testing factory and counter equality", c2, c4);
        CounterTestBase.assertEquals((String)"Testing factory", (Object)c2.totalCount(), (Object)-1.0);
        c3.addAll(c2);
        CounterTestBase.assertEquals((int)c3.keySet().size(), (int)3);
        CounterTestBase.assertEquals((int)c3.size(), (int)3);
        CounterTestBase.assertEquals((String)"Testing addAll", (Object)-2.0, (Object)c3.totalCount());
    }

    public void testReturnValue() {
        this.c.setDefaultReturnValue(-1.0);
        CounterTestBase.assertEquals((Object)this.c.defaultReturnValue(), (Object)-1.0);
        CounterTestBase.assertEquals((Object)this.c.getCount("-!-"), (Object)-1.0);
        this.c.setDefaultReturnValue(0.0);
        CounterTestBase.assertEquals((Object)this.c.getCount("-!-"), (Object)0.0);
    }

    public void testSetCount() {
        this.c.clear();
        this.c.setCount("p", 0.0);
        this.c.setCount("q", 2.0);
        CounterTestBase.assertEquals((String)"Failed setCount", (Object)2.0, (Object)this.c.totalCount());
        CounterTestBase.assertEquals((String)"Failed setCount", (Object)2.0, (Object)this.c.getCount("q"));
    }

    public void testIncrement() {
        this.c.clear();
        CounterTestBase.assertEquals((Object)0.0, (Object)this.c.getCount("r"));
        CounterTestBase.assertEquals((Object)1.0, (Object)this.c.incrementCount("r"));
        CounterTestBase.assertEquals((Object)1.0, (Object)this.c.getCount("r"));
        this.c.setCount("p", 0.0);
        this.c.setCount("q", 2.0);
        CounterTestBase.assertEquals((boolean)true, (boolean)this.c.containsKey("q"));
        CounterTestBase.assertEquals((boolean)false, (boolean)this.c.containsKey("!!!"));
        CounterTestBase.assertEquals((Object)0.0, (Object)this.c.getCount("p"));
        CounterTestBase.assertEquals((Object)1.0, (Object)this.c.incrementCount("p"));
        CounterTestBase.assertEquals((Object)1.0, (Object)this.c.getCount("p"));
        CounterTestBase.assertEquals((Object)4.0, (Object)this.c.totalCount());
        this.c.decrementCount("s", 5.0);
        CounterTestBase.assertEquals((Object)-5.0, (Object)this.c.getCount("s"));
        this.c.remove("s");
        CounterTestBase.assertEquals((Object)4.0, (Object)this.c.totalCount());
    }

    public void testIncrement2() {
        this.c.clear();
        this.c.setCount("p", 0.5);
        this.c.setCount("q", 2.0);
        if (this.integral) {
            CounterTestBase.assertEquals((Object)3.0, (Object)this.c.incrementCount("p", 3.5));
            CounterTestBase.assertEquals((Object)3.0, (Object)this.c.getCount("p"));
            CounterTestBase.assertEquals((Object)5.0, (Object)this.c.totalCount());
        } else {
            CounterTestBase.assertEquals((Object)4.0, (Object)this.c.incrementCount("p", 3.5));
            CounterTestBase.assertEquals((Object)4.0, (Object)this.c.getCount("p"));
            CounterTestBase.assertEquals((Object)6.0, (Object)this.c.totalCount());
        }
    }

    public void testLogIncrement() {
        this.c.clear();
        this.c.setCount("p", Math.log(0.5));
        this.c.setCount("q", Math.log(0.2));
        if (this.integral) {
            double ans = this.c.logIncrementCount("p", Math.log(0.3));
            CounterTestBase.assertEquals((double)0.0, (double)ans, (double)1.0E-4);
            CounterTestBase.assertEquals((double)-1.0, (double)this.c.totalCount(), (double)1.0E-4);
        } else {
            CounterTestBase.assertEquals((double)Math.log(0.8), (double)this.c.logIncrementCount("p", Math.log(0.3)), (double)1.0E-4);
            CounterTestBase.assertEquals((double)(Math.log(0.8) + Math.log(0.2)), (double)this.c.totalCount(), (double)1.0E-4);
        }
    }

    public void testEntrySet() {
        this.c.clear();
        this.c.setCount("r", 3.0);
        this.c.setCount("p", 1.0);
        this.c.setCount("q", 2.0);
        this.c.setCount("s", 4.0);
        CounterTestBase.assertEquals((Object)10.0, (Object)this.c.totalCount());
        CounterTestBase.assertEquals((Object)1.0, (Object)this.c.getCount("p"));
        for (Map.Entry<String, Double> entry : this.c.entrySet()) {
            if (!entry.getKey().equals("p")) continue;
            CounterTestBase.assertEquals((Object)1.0, (Object)entry.setValue(3.0));
            CounterTestBase.assertEquals((Object)3.0, (Object)entry.getValue());
        }
        CounterTestBase.assertEquals((Object)3.0, (Object)this.c.getCount("p"));
        CounterTestBase.assertEquals((Object)12.0, (Object)this.c.totalCount());
        Collection<Double> vals = this.c.values();
        double tot = 0.0;
        for (double d : vals) {
            tot += d;
        }
        CounterTestBase.assertEquals((String)"Testing values()", (Object)12.0, (Object)tot);
    }

    public void testComparators() {
        this.c.clear();
        this.c.setCount("b", 3.0);
        this.c.setCount("p", -5.0);
        this.c.setCount("a", 2.0);
        this.c.setCount("s", 4.0);
        ArrayList<String> list = new ArrayList<String>(this.c.keySet());
        Comparator<String> cmp = Counters.toComparator(this.c);
        Collections.sort(list, cmp);
        CounterTestBase.assertEquals((int)4, (int)list.size());
        CounterTestBase.assertEquals((String)"p", (String)((String)list.get(0)));
        CounterTestBase.assertEquals((String)"a", (String)((String)list.get(1)));
        CounterTestBase.assertEquals((String)"b", (String)((String)list.get(2)));
        CounterTestBase.assertEquals((String)"s", (String)((String)list.get(3)));
        Comparator<String> cmp2 = Counters.toComparatorDescending(this.c);
        Collections.sort(list, cmp2);
        CounterTestBase.assertEquals((int)4, (int)list.size());
        CounterTestBase.assertEquals((String)"p", (String)((String)list.get(3)));
        CounterTestBase.assertEquals((String)"a", (String)((String)list.get(2)));
        CounterTestBase.assertEquals((String)"b", (String)((String)list.get(1)));
        CounterTestBase.assertEquals((String)"s", (String)((String)list.get(0)));
        Comparator<String> cmp3 = Counters.toComparator(this.c, true, true);
        Collections.sort(list, cmp3);
        CounterTestBase.assertEquals((int)4, (int)list.size());
        CounterTestBase.assertEquals((String)"p", (String)((String)list.get(3)));
        CounterTestBase.assertEquals((String)"a", (String)((String)list.get(0)));
        CounterTestBase.assertEquals((String)"b", (String)((String)list.get(1)));
        CounterTestBase.assertEquals((String)"s", (String)((String)list.get(2)));
        Comparator<String> cmp4 = Counters.toComparator(this.c, false, true);
        Collections.sort(list, cmp4);
        CounterTestBase.assertEquals((int)4, (int)list.size());
        CounterTestBase.assertEquals((String)"p", (String)((String)list.get(0)));
        CounterTestBase.assertEquals((String)"a", (String)((String)list.get(3)));
        CounterTestBase.assertEquals((String)"b", (String)((String)list.get(2)));
        CounterTestBase.assertEquals((String)"s", (String)((String)list.get(1)));
        Comparator<String> cmp5 = Counters.toComparator(this.c, false, false);
        Collections.sort(list, cmp5);
        CounterTestBase.assertEquals((int)4, (int)list.size());
        CounterTestBase.assertEquals((String)"p", (String)((String)list.get(3)));
        CounterTestBase.assertEquals((String)"a", (String)((String)list.get(2)));
        CounterTestBase.assertEquals((String)"b", (String)((String)list.get(1)));
        CounterTestBase.assertEquals((String)"s", (String)((String)list.get(0)));
    }

    public void testClear() {
        this.c.incrementCount("xy", 30.0);
        this.c.clear();
        CounterTestBase.assertEquals((Object)0.0, (Object)this.c.totalCount());
    }
}

