/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.io.RecordIterator;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public interface DataSeries {
    public static final Redwood.RedwoodChannels log = Redwood.channels(DataSeries.class);

    public String name();

    public double get(int var1);

    public int size();

    public DataSeries domain();

    public static class AverageDataSeries
    implements DataSeries {
        private DataSeries[] components;

        public AverageDataSeries(DataSeries[] components) {
            if (components == null || components.length < 1) {
                throw new IllegalArgumentException("Need at least one component!");
            }
            this.components = new DataSeries[components.length];
            for (int i = 0; i < components.length; ++i) {
                if (components[i] == null) {
                    throw new IllegalArgumentException("Can't have null components!");
                }
                this.components[i] = components[i];
            }
            this.domain();
        }

        @Override
        public String name() {
            StringBuilder name = new StringBuilder();
            name.append("avg(");
            boolean flag = false;
            for (DataSeries series : this.components) {
                if (flag) {
                    name.append(", ");
                } else {
                    flag = true;
                }
                name.append(series.name());
            }
            name.append(")");
            return name.toString();
        }

        @Override
        public double get(int i) {
            double y = 0.0;
            for (DataSeries series : this.components) {
                y += series.get(i);
            }
            return y / (double)this.components.length;
        }

        @Override
        public int size() {
            int size = Integer.MAX_VALUE;
            for (DataSeries series : this.components) {
                size = Math.min(size, series.size());
            }
            return size;
        }

        @Override
        public DataSeries domain() {
            DataSeries domain = this.components[0].domain();
            for (DataSeries series : this.components) {
                if (series.domain() == domain) continue;
                throw new IllegalStateException("The components of this AverageDataSeries do not have the same domains!");
            }
            return domain;
        }

        public String toString() {
            return this.name();
        }
    }

    public static class ListDataSeries
    extends AbstractDataSeries {
        private List<Double> data;

        public ListDataSeries(String name) {
            this.setName(name);
            this.setData(new ArrayList<Double>());
        }

        public ListDataSeries(String name, List<Double> data) {
            this(name);
            this.setData(data);
        }

        public ListDataSeries(String name, List<Double> data, DataSeries domain) {
            this(name, data);
            this.setDomain(domain);
        }

        public ListDataSeries(String name, DataSeries domain) {
            this(name);
            this.setDomain(domain);
        }

        public List<Double> data() {
            return this.data;
        }

        public void setData(List<Double> data) {
            if (data == null) {
                throw new NullPointerException();
            }
            this.data = data;
        }

        @Override
        public double get(int i) {
            if (i < 0 || i >= this.data.size()) {
                return i;
            }
            return this.data.get(i);
        }

        public void set(int i, double x) {
            if (i < 0 || i >= this.data.size()) {
                return;
            }
            this.data.set(i, x);
        }

        public void add(double x) {
            this.data.add(new Double(x));
        }

        @Override
        public int size() {
            return this.data.size();
        }

        public static DataSeries[] readDataSeries(RecordIterator it, boolean useHeaders) {
            if (!it.hasNext()) {
                return null;
            }
            Object record = it.next();
            int columns = record.size();
            if (columns < 1) {
                throw new IllegalArgumentException();
            }
            DataSeries[] serieses = new ListDataSeries[columns];
            for (int col = 0; col < columns; ++col) {
                ListDataSeries series = new ListDataSeries("y" + col);
                if (col == 0) {
                    series.setName("x");
                } else {
                    series.setDomain(serieses[0]);
                }
                serieses[col] = series;
            }
            if (useHeaders) {
                for (int i = 0; i < record.size() && i < serieses.length; ++i) {
                    ((AbstractDataSeries)serieses[i]).setName((String)record.get(i));
                }
                record = it.next();
            }
            while (true) {
                try {
                    int col;
                    double[] values = new double[columns];
                    for (col = 0; col < columns; ++col) {
                        values[col] = Double.valueOf((String)record.get(col));
                    }
                    for (col = 0; col < columns; ++col) {
                        ((ListDataSeries)serieses[col]).add(values[col]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!it.hasNext()) break;
                record = it.next();
            }
            return serieses;
        }

        public static DataSeries[] readDataSeries(InputStream in, boolean useHeaders) {
            return ListDataSeries.readDataSeries(new RecordIterator(in), useHeaders);
        }

        public static DataSeries[] readDataSeries(InputStream in) {
            return ListDataSeries.readDataSeries(new RecordIterator(in), false);
        }

        public static DataSeries[] readDataSeries(String filename, boolean useHeaders) throws FileNotFoundException {
            return ListDataSeries.readDataSeries(new RecordIterator(filename), useHeaders);
        }

        public static DataSeries[] readDataSeries(String filename) throws FileNotFoundException {
            return ListDataSeries.readDataSeries(new RecordIterator(filename), false);
        }

        public static void main(String[] args) throws FileNotFoundException {
            DataSeries[] serieses = null;
            if (args.length > 0) {
                serieses = ListDataSeries.readDataSeries(args[0], true);
            } else {
                log.info("[Reading from stdin...]");
                serieses = ListDataSeries.readDataSeries(System.in, true);
            }
            for (DataSeries series : serieses) {
                System.out.print(series.name() + ": ");
                System.out.println(((ListDataSeries)series).toListPairDouble());
            }
        }

        private static void demo1() {
            ListDataSeries xData = new ListDataSeries("x");
            ListDataSeries yData = new ListDataSeries("y", xData);
            for (double x = 0.0; x < 5.0; x += 1.0) {
                xData.add(x);
                yData.add(x * x);
            }
            System.out.println(yData.toListPairDouble());
        }
    }

    public static class ArrayDataSeries
    extends AbstractDataSeries {
        private double[] data;

        public ArrayDataSeries(String name) {
            this.setName(name);
            this.setData(new double[0]);
        }

        public ArrayDataSeries(String name, double[] data) {
            this(name);
            this.setData(data);
        }

        public ArrayDataSeries(String name, double[] data, DataSeries domain) {
            this(name, data);
            this.setDomain(domain);
        }

        public double[] data() {
            return this.data;
        }

        public void setData(double[] data) {
            if (data == null) {
                throw new NullPointerException();
            }
            this.data = data;
        }

        @Override
        public double get(int i) {
            if (i < 0 || i >= this.data.length) {
                return i;
            }
            return this.data[i];
        }

        public void set(int i, double x) {
            if (i < 0 || i >= this.data.length) {
                return;
            }
            this.data[i] = x;
        }

        @Override
        public int size() {
            return this.data.length;
        }
    }

    public static class FunctionDataSeries
    extends AbstractDataSeries {
        private Function<Object, Integer> sizeFn;
        private Function<Integer, Double> function;

        public FunctionDataSeries(String name, Function<Integer, Double> function, Function<Object, Integer> sizeFn, DataSeries domain) {
            this.setName(name);
            this.function = function;
            this.sizeFn = sizeFn;
            this.setDomain(domain);
        }

        public FunctionDataSeries(String name, Function<Integer, Double> function, Function<Object, Integer> sizeFn) {
            this(name, function, sizeFn, null);
        }

        public FunctionDataSeries(String name, Function<Integer, Double> function, int size, DataSeries domain) {
            this(name, function, FunctionDataSeries.constantSizeFn(size), domain);
        }

        public FunctionDataSeries(String name, Function<Integer, Double> function, int size) {
            this(name, function, size, null);
        }

        @Override
        public double get(int i) {
            if (i < 0 || i >= this.size()) {
                return i;
            }
            return this.function.apply(i);
        }

        @Override
        public int size() {
            return this.sizeFn.apply(null);
        }

        private static Function<Object, Integer> constantSizeFn(int size) {
            return o -> size;
        }
    }

    public static abstract class AbstractDataSeries
    implements DataSeries {
        private String name;
        private DataSeries domain;

        @Override
        public String name() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public DataSeries domain() {
            return this.domain;
        }

        public void setDomain(DataSeries domain) {
            this.domain = domain;
        }

        public List<Pair<Double, Double>> toListPairDouble() {
            ArrayList<Pair<Double, Double>> list = new ArrayList<Pair<Double, Double>>();
            for (int i = 0; i < this.size(); ++i) {
                double x = this.domain() != null ? this.domain().get(i) : (double)i;
                double y = this.get(i);
                list.add(new Pair<Double, Double>(x, y));
            }
            return list;
        }
    }
}

