/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.TwoDimensionalIntCounter;
import junit.framework.TestCase;

public class TwoDimensionalIntCounterTest
extends TestCase {
    public void testTraditionalMain() {
        TwoDimensionalIntCounter<String, String> cc = new TwoDimensionalIntCounter<String, String>();
        cc.setCount("a", "c", 1.0);
        cc.setCount("b", "c", 1.0);
        cc.setCount("a", "d", 1.0);
        cc.setCount("a", "d", -1.0);
        cc.setCount("b", "d", 1.0);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter setup", (double)1.0, (double)cc.getCount("a", "c"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter setup", (double)1.0, (double)cc.getCount("b", "c"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter setup", (double)-1.0, (double)cc.getCount("a", "d"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter setup", (double)1.0, (double)cc.getCount("b", "d"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter setup", (double)0.0, (double)cc.getCount("a", "a"), (double)1.0E-8);
        cc.incrementCount("b", "d", 1.0);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter increment", (double)-1.0, (double)cc.getCount("a", "d"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter increment", (double)2.0, (double)cc.getCount("b", "d"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter increment", (double)0.0, (double)cc.getCount("a", "a"), (double)1.0E-8);
        TwoDimensionalIntCounter<String, String> cc2 = TwoDimensionalIntCounter.reverseIndexOrder(cc);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter reverseIndexOrder", (double)1.0, (double)cc2.getCount("c", "a"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter reverseIndexOrder", (double)1.0, (double)cc2.getCount("c", "b"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter reverseIndexOrder", (double)-1.0, (double)cc2.getCount("d", "a"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter reverseIndexOrder", (double)2.0, (double)cc2.getCount("d", "b"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter reverseIndexOrder", (double)0.0, (double)cc2.getCount("a", "a"), (double)1.0E-8);
        TwoDimensionalIntCounterTest.assertEquals((String)"Error in counter reverseIndexOrder", (double)0.0, (double)cc2.getCount("a", "c"), (double)1.0E-8);
    }
}

