/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.io;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TSVTaggedFileReaderTest
extends TestCase {
    static final String TEST_FILE = "A\t1\nB\t2\nC\t3\n\nD\t4\nE\t5\n\n\n\nF\t6\n\n\n";

    File createFile(String data) throws IOException {
        File file = File.createTempFile("TSVTaggedFileReaderTest", "txt");
        FileWriter fout = new FileWriter(file);
        fout.write(data);
        fout.close();
        return file;
    }

    File createTestFile() throws IOException {
        return this.createFile(TEST_FILE);
    }

    File createBrokenFile() throws IOException {
        return this.createFile("A\nB\n\n");
    }

    TaggedFileRecord createRecord(File file, String extraArgs) {
        String description = extraArgs + "format=TSV," + file;
        Properties props = new Properties();
        return TaggedFileRecord.createRecord(props, description);
    }

    public void testReadNormal() throws IOException {
        File file = this.createTestFile();
        TaggedFileRecord record = this.createRecord(file, "");
        ArrayList<List> sentences = new ArrayList<List>();
        for (List sentence : record.reader()) {
            sentences.add(sentence);
        }
        TSVTaggedFileReaderTest.assertEquals((int)3, (int)sentences.size());
        TSVTaggedFileReaderTest.assertEquals((int)3, (int)((List)sentences.get(0)).size());
        TSVTaggedFileReaderTest.assertEquals((String)"A", (String)((TaggedWord)((List)sentences.get(0)).get(0)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"B", (String)((TaggedWord)((List)sentences.get(0)).get(1)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"C", (String)((TaggedWord)((List)sentences.get(0)).get(2)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"D", (String)((TaggedWord)((List)sentences.get(1)).get(0)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"E", (String)((TaggedWord)((List)sentences.get(1)).get(1)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"F", (String)((TaggedWord)((List)sentences.get(2)).get(0)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"1", (String)((TaggedWord)((List)sentences.get(0)).get(0)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"2", (String)((TaggedWord)((List)sentences.get(0)).get(1)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"3", (String)((TaggedWord)((List)sentences.get(0)).get(2)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"4", (String)((TaggedWord)((List)sentences.get(1)).get(0)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"5", (String)((TaggedWord)((List)sentences.get(1)).get(1)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"6", (String)((TaggedWord)((List)sentences.get(2)).get(0)).tag());
    }

    public void testReadBackwards() throws IOException {
        File file = this.createTestFile();
        TaggedFileRecord record = this.createRecord(file, "tagColumn=0,wordColumn=1,");
        ArrayList<List> sentences = new ArrayList<List>();
        for (List sentence : record.reader()) {
            sentences.add(sentence);
        }
        TSVTaggedFileReaderTest.assertEquals((int)3, (int)sentences.size());
        TSVTaggedFileReaderTest.assertEquals((int)3, (int)((List)sentences.get(0)).size());
        TSVTaggedFileReaderTest.assertEquals((String)"A", (String)((TaggedWord)((List)sentences.get(0)).get(0)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"B", (String)((TaggedWord)((List)sentences.get(0)).get(1)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"C", (String)((TaggedWord)((List)sentences.get(0)).get(2)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"D", (String)((TaggedWord)((List)sentences.get(1)).get(0)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"E", (String)((TaggedWord)((List)sentences.get(1)).get(1)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"F", (String)((TaggedWord)((List)sentences.get(2)).get(0)).tag());
        TSVTaggedFileReaderTest.assertEquals((String)"1", (String)((TaggedWord)((List)sentences.get(0)).get(0)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"2", (String)((TaggedWord)((List)sentences.get(0)).get(1)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"3", (String)((TaggedWord)((List)sentences.get(0)).get(2)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"4", (String)((TaggedWord)((List)sentences.get(1)).get(0)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"5", (String)((TaggedWord)((List)sentences.get(1)).get(1)).word());
        TSVTaggedFileReaderTest.assertEquals((String)"6", (String)((TaggedWord)((List)sentences.get(2)).get(0)).word());
    }

    public void testError() throws IOException {
        File file = this.createBrokenFile();
        TaggedFileRecord record = this.createRecord(file, "tagColumn=0,wordColumn=1,");
        try {
            Iterator iterator = record.reader().iterator();
            if (iterator.hasNext()) {
                List sentence = (List)iterator.next();
                throw new AssertionError((Object)"Should have thrown an error  reading a file with no tags");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

