/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.util.Generics;
import java.io.File;
import junit.framework.TestCase;

public class TTagsTest
extends TestCase {
    private TTags tt;

    protected void setUp() {
        this.tt = new TTags();
    }

    public void testUniqueness() {
        int b;
        int a = this.tt.add("one");
        TTagsTest.assertTrue((a != (b = this.tt.add("two")) ? 1 : 0) != 0);
    }

    public void testSameness() {
        int a = this.tt.add("goat");
        int b = this.tt.add("goat");
        TTagsTest.assertEquals((int)a, (int)b);
    }

    public void testPreservesString() {
        int a = this.tt.add("monkey");
        String s = this.tt.getTag(a);
        TTagsTest.assertEquals((String)s, (String)"monkey");
    }

    public void testPreservesIndex() {
        int a = this.tt.add("spunky");
        int b = this.tt.getIndex("spunky");
        TTagsTest.assertEquals((int)a, (int)b);
    }

    public void testCanCount() {
        int s = this.tt.getSize();
        this.tt.add("asdfdsaefasfdsaf");
        int s2 = this.tt.getSize();
        TTagsTest.assertEquals((int)(s + 1), (int)s2);
    }

    public void testHoldsLotsOfStuff() {
        try {
            for (int i = 0; i < 1000; ++i) {
                this.tt.add("fake" + Integer.toString(i));
            }
        }
        catch (Exception e) {
            TTagsTest.fail((String)("couldn't put lots of stuff in:" + e.getMessage()));
        }
    }

    public void testClosed() {
        this.tt.add("java");
        TTagsTest.assertFalse((boolean)this.tt.isClosed("java"));
        this.tt.markClosed("java");
        TTagsTest.assertTrue((boolean)this.tt.isClosed("java"));
    }

    public void testSerialization() {
        for (int i = 0; i < 100; ++i) {
            this.tt.add("fake" + Integer.toString(i));
        }
        this.tt.markClosed("fake44");
        this.tt.add("boat");
        this.tt.save("testoutputfile", Generics.newHashMap());
        TTags t2 = new TTags();
        t2.read("testoutputfile");
        TTagsTest.assertEquals((int)this.tt.getSize(), (int)t2.getSize());
        TTagsTest.assertEquals((int)this.tt.getIndex("boat"), (int)t2.getIndex("boat"));
        TTagsTest.assertEquals((String)t2.getTag(this.tt.getIndex("boat")), (String)"boat");
        TTagsTest.assertFalse((boolean)t2.isClosed("fake43"));
        TTagsTest.assertTrue((boolean)t2.isClosed("fake44"));
        new File("testoutputfile").delete();
    }
}

