/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.util;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ConvertTreesToTags {
    private static Redwood.RedwoodChannels log = Redwood.channels(ConvertTreesToTags.class);

    private ConvertTreesToTags() {
    }

    public static void main(String[] args) throws IOException {
        String outputFilename = "";
        String tagSeparator = "";
        String treeRange = "";
        String inputEncoding = "UTF-8";
        String outputEncoding = "UTF-8";
        String treeFilter = "";
        boolean noTags = false;
        boolean noSpaces = false;
        ArrayList<String> inputFilenames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if ((args[i].equalsIgnoreCase("-output") || args[i].equalsIgnoreCase("--output")) && i + 1 < args.length) {
                outputFilename = args[i + 1];
                ++i;
                continue;
            }
            if ((args[i].equalsIgnoreCase("-tagSeparator") || args[i].equalsIgnoreCase("--tagSeparator")) && i + 1 < args.length) {
                tagSeparator = args[i + 1];
                ++i;
                continue;
            }
            if ((args[i].equalsIgnoreCase("-treeRange") || args[i].equalsIgnoreCase("--treeRange")) && i + 1 < args.length) {
                treeRange = args[i + 1];
                ++i;
                continue;
            }
            if ((args[i].equalsIgnoreCase("-inputEncoding") || args[i].equalsIgnoreCase("--inputEncoding")) && i + 1 < args.length) {
                inputEncoding = args[i + 1];
                ++i;
                continue;
            }
            if ((args[i].equalsIgnoreCase("-outputEncoding") || args[i].equalsIgnoreCase("--outputEncoding")) && i + 1 < args.length) {
                outputEncoding = args[i + 1];
                ++i;
                continue;
            }
            if ((args[i].equalsIgnoreCase("-treeFilter") || args[i].equalsIgnoreCase("--treeFilter")) && i + 1 < args.length) {
                treeFilter = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-noTags") || args[i].equalsIgnoreCase("--noTags")) {
                noTags = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-noSpaces") || args[i].equalsIgnoreCase("--noSpaces")) {
                noSpaces = true;
                continue;
            }
            inputFilenames.add(args[i]);
        }
        if (outputFilename.equals("")) {
            log.info("Must specify an output filename, -output");
            System.exit(2);
        }
        if (inputFilenames.size() == 0) {
            log.info("Must specify one or more input filenames");
            System.exit(2);
        }
        FileOutputStream fos = new FileOutputStream(outputFilename);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, outputEncoding);
        BufferedWriter bout = new BufferedWriter(osw);
        Properties props = new Properties();
        for (String filename : inputFilenames) {
            String description = "format=" + (Object)((Object)TaggedFileRecord.Format.TREES) + "," + filename;
            if (!treeRange.equals("")) {
                description = "treeRange=" + treeRange + "," + description;
            }
            if (!treeFilter.equals("")) {
                description = "treeFilter=" + treeFilter + "," + description;
            }
            description = "encoding=" + inputEncoding + "," + description;
            TaggedFileRecord record = TaggedFileRecord.createRecord(props, description);
            for (List sentence : record.reader()) {
                String output = SentenceUtils.listToString(sentence, noTags, tagSeparator);
                if (noSpaces) {
                    output = output.replaceAll(" ", "");
                }
                bout.write(output);
                bout.newLine();
            }
        }
        bout.flush();
        bout.close();
        osw.close();
        fos.close();
    }
}

