/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time.suservlet;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.time.GUTimeAnnotator;
import edu.stanford.nlp.time.HeidelTimeAnnotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeAnnotator;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class SUTimePipeline {
    private static Redwood.RedwoodChannels log = Redwood.channels(SUTimePipeline.class);
    final StanfordCoreNLP pipeline;

    public SUTimePipeline() {
        this(new Properties());
    }

    public SUTimePipeline(Properties props) {
        if (props.getProperty("annotators") == null) {
            props.setProperty("annotators", "tokenize, ssplit, pos");
        }
        props.setProperty("tokenize.options", "invertible,ptb3Escaping=true");
        this.pipeline = new StanfordCoreNLP(props);
    }

    public boolean isDateOkay(String dateString) {
        return true;
    }

    public Annotator getTimeAnnotator(String annotatorType, Properties props) {
        switch (annotatorType) {
            case "sutime": {
                return new TimeAnnotator("sutime", props);
            }
            case "gutime": {
                return new GUTimeAnnotator("gutime", props);
            }
            case "heideltime": {
                return new HeidelTimeAnnotator("heidelTime", props);
            }
        }
        return null;
    }

    public Annotation process(String sentence, String dateString, Annotator timeAnnotator) {
        log.info("Processing text \"" + sentence + "\" with dateString = " + dateString);
        Annotation anno = new Annotation(sentence);
        if (dateString != null && !dateString.equals("")) {
            anno.set(CoreAnnotations.DocDateAnnotation.class, dateString);
        }
        this.pipeline.annotate(anno);
        timeAnnotator.annotate(anno);
        return anno;
    }

    public static void main(String[] args) throws IOException {
        String line;
        SUTimePipeline pipeline = new SUTimePipeline();
        Annotator timeAnnotator = pipeline.getTimeAnnotator("sutime", new Properties());
        BufferedReader is = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("> ");
        while ((line = is.readLine()) != null) {
            Annotation ann = pipeline.process(line, null, timeAnnotator);
            System.out.println(ann.get(TimeAnnotations.TimexAnnotations.class));
            System.out.print("> ");
        }
    }
}

