/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import java.util.Arrays;

public class CollinsRelation {
    private final String parent;
    private final String head;
    private final String modifier;
    private final Direction direction;
    private static int defaultPadding = 8;

    public CollinsRelation(String par, String head, String mod, Direction dir) {
        this.parent = par;
        this.head = head;
        this.modifier = mod;
        this.direction = dir;
    }

    public String toString() {
        String dir = this.direction == Direction.Left ? "L" : "R";
        return String.format("%s%s%s%s", CollinsRelation.pad(this.parent), CollinsRelation.pad(this.head), CollinsRelation.pad(this.modifier), dir);
    }

    private static String pad(String s) {
        if (s == null) {
            return s;
        }
        int add = defaultPadding - s.length();
        if (add <= 0) {
            return s;
        }
        StringBuffer str = new StringBuffer(s);
        char[] ch = new char[add];
        Arrays.fill(ch, ' ');
        str.append(ch);
        return str.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CollinsRelation)) {
            return false;
        }
        CollinsRelation otherRel = (CollinsRelation)other;
        return this.parent.equals(otherRel.parent) && this.head.equals(otherRel.head) && this.modifier.equals(otherRel.modifier) && this.direction == otherRel.direction;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 68 * this.parent.hashCode();
        hash *= 983 * this.modifier.hashCode();
        hash *= 672 * this.head.hashCode();
        return hash *= this.direction == Direction.Left ? -1 : 1;
    }

    public static enum Direction {
        Left,
        Right;

    }
}

