/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class GenerateTrees {
    Map<String, Counter<List<String>>> nonTerminals = Generics.newHashMap();
    Map<String, Counter<String>> terminals = Generics.newHashMap();
    List<Pair<TregexPattern, TsurgeonPattern>> tsurgeons = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
    Random random = new Random();
    LabeledScoredTreeFactory tf = new LabeledScoredTreeFactory();
    TregexPatternCompiler compiler = new TregexPatternCompiler();
    TreePrint tp = new TreePrint("penn");

    public void readGrammar(String filename) {
        try {
            FileReader fin = new FileReader(filename);
            BufferedReader bin = new BufferedReader(fin);
            this.readGrammar(bin);
            bin.close();
            fin.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void readGrammar(BufferedReader bin) {
        try {
            String line;
            Section section = Section.TERMINALS;
            block9: while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.length() > 0 && line.charAt(0) == '#') continue;
                try {
                    Section newSection = Section.valueOf(line.toUpperCase());
                    section = newSection;
                    if (section != Section.TSURGEON) continue;
                    Pair<TregexPattern, TsurgeonPattern> operation = Tsurgeon.getOperationFromReader(bin, this.compiler);
                    this.tsurgeons.add(operation);
                }
                catch (IllegalArgumentException newSection) {
                    String[] pieces = line.split(" +");
                    switch (section) {
                        case TSURGEON: {
                            throw new RuntimeException("Found a non-empty line in a tsurgeon section after reading the operation");
                        }
                        case TERMINALS: {
                            Counter<Object> productions = this.terminals.get(pieces[0]);
                            if (productions == null) {
                                productions = new ClassicCounter<String>();
                                this.terminals.put(pieces[0], productions);
                            }
                            for (int i = 1; i < pieces.length; ++i) {
                                productions.incrementCount(pieces[i]);
                            }
                            continue block9;
                        }
                        case NONTERMINALS: {
                            Counter<Object> productions = this.nonTerminals.get(pieces[0]);
                            if (productions == null) {
                                productions = new ClassicCounter<String>();
                                this.nonTerminals.put(pieces[0], productions);
                            }
                            String[] sublist = Arrays.copyOfRange(pieces, 1, pieces.length);
                            productions.incrementCount(Arrays.asList(sublist));
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void produceTrees(String filename, int numTrees) {
        try {
            FileWriter fout = new FileWriter(filename);
            BufferedWriter bout = new BufferedWriter(fout);
            PrintWriter pout = new PrintWriter(bout);
            this.produceTrees(pout, numTrees);
            pout.close();
            bout.close();
            fout.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void produceTrees(PrintWriter pout, int numTrees) {
        for (int i = 0; i < numTrees; ++i) {
            Tree tree = this.produceTree("ROOT");
            Tsurgeon.processPatternsOnTree(this.tsurgeons, tree);
            this.tp.printTree(tree, pout);
        }
    }

    public Tree produceTree(String state) {
        Counter<String> terminal = this.terminals.get(state);
        if (terminal != null) {
            String label = Counters.sample(terminal, this.random);
            Tree child = this.tf.newLeaf(label);
            List<Tree> children = Collections.singletonList(child);
            Tree root = this.tf.newTreeNode(state, children);
            return root;
        }
        Counter<List<String>> nonTerminal = this.nonTerminals.get(state);
        if (nonTerminal != null) {
            List<String> labels = Counters.sample(nonTerminal, this.random);
            ArrayList<Tree> children = new ArrayList<Tree>();
            for (String childLabel : labels) {
                children.add(this.produceTree(childLabel));
            }
            Tree root = this.tf.newTreeNode(state, children);
            return root;
        }
        throw new RuntimeException("Unknown state " + state);
    }

    public static void help() {
        System.out.println("Command line should be ");
        System.out.println("  edu.stanford.nlp.trees.GenerateTrees <input> <output> <numtrees>");
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0].equals("-h")) {
            GenerateTrees.help();
            System.exit(0);
        }
        GenerateTrees grammar = new GenerateTrees();
        grammar.readGrammar(args[0]);
        int numTrees = Integer.valueOf(args[2]);
        grammar.produceTrees(args[1], numTrees);
    }

    static enum Section {
        TERMINALS,
        NONTERMINALS,
        TSURGEON;

    }
}

