/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TypedDependency;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class GrammaticalStructureTest
extends TestCase {
    public HashSet<String> tokenSet(String tokenString) {
        Pattern tokenPattern = Pattern.compile("(\\S+\\(\\S+-\\d+, \\S+-\\d+\\))");
        Matcher tpMatcher = tokenPattern.matcher(tokenString);
        HashSet<String> tokenSet = new HashSet<String>();
        while (tpMatcher.find()) {
            tokenSet.add(tpMatcher.group());
        }
        return tokenSet;
    }

    public HashSet<String> tokenSet(List<TypedDependency> ds) {
        HashSet<String> tokenSet = new HashSet<String>();
        for (TypedDependency d : ds) {
            tokenSet.add(d.toString());
        }
        return tokenSet;
    }

    public void testEnglishDependenciesByTree() {
        String[] testTrees = new String[]{"((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN book)) (SBAR (WHNP (WDT which)) (S (NP (PRP you)) (VP (VBD bought)))))) (. .)))"};
        String[] testAnswers = new String[]{"root(ROOT-0, died-2) nsubj(died-2, Sam-1) tmod(died-2, today-3)", "nsubj(saw-2, I-1) root(ROOT-0, saw-2) det(book-4, the-3) dobj(saw-2, book-4) dobj(bought-7, which-5) ref(book-4, which-5) dobj(bought-7, which-5) nsubj(bought-7, you-6) rcmod(book-4, bought-7)"};
        String[] testAnswersCollapsed = new String[]{"root(ROOT-0, died-2) nsubj(died-2, Sam-1) tmod(died-2, today-3)", "nsubj(saw-2, I-1) root(ROOT-0, saw-2) det(book-4, the-3) dobj(saw-2, book-4) dobj(bought-7, book-4) nsubj(bought-7, you-6) rcmod(book-4, bought-7)"};
        String[] testAnswersCCProcessed = new String[]{"root(ROOT-0, died-2) nsubj(died-2, Sam-1) tmod(died-2, today-3)", "nsubj(saw-2, I-1) root(ROOT-0, saw-2) det(book-4, the-3) dobj(saw-2, book-4) dobj(bought-7, book-4) nsubj(bought-7, you-6) rcmod(book-4, bought-7)"};
        for (int i = 0; i < testTrees.length; ++i) {
            Tree tree;
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            String testAnswerCollapsed = testAnswersCollapsed[i];
            String testAnswerCCProcessed = testAnswersCCProcessed[i];
            HashSet<String> testAnswerTokens = this.tokenSet(testAnswer);
            HashSet<String> testAnswerCollapsedTokens = this.tokenSet(testAnswerCollapsed);
            HashSet<String> testAnswerCCProcessedTokens = this.tokenSet(testAnswerCCProcessed);
            try {
                tree = new PennTreeReader(new StringReader(testTree), new LabeledScoredTreeFactory()).readTree();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            GrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), testAnswerTokens, this.tokenSet(gs.typedDependencies(GrammaticalStructure.Extras.MAXIMAL)));
            GrammaticalStructureTest.assertEquals((String)("Unexpected collapsed dependencies for tree " + testTree), testAnswerCollapsedTokens, this.tokenSet(gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL)));
            GrammaticalStructureTest.assertEquals((String)("Unexpected cc-processed dependencies for tree " + testTree), testAnswerCCProcessedTokens, this.tokenSet(gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL)));
        }
    }
}

