/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;

public class PennTreeReaderTest
extends TestCase {
    public void testRead() throws IOException {
        String treeText = "(1 (2 This)) (3 (4 is) (5 a)) (6 (\\* small) (7 \\/test))";
        StringReader reader = new StringReader(treeText);
        PennTreeReader treeReader = new PennTreeReader(reader);
        String[] expected = new String[]{"(1 (2 This))", "(3 (4 is) (5 a))", "(6 (* small) (7 /test))"};
        for (int i = 0; i < expected.length; ++i) {
            Tree tree = treeReader.readTree();
            PennTreeReaderTest.assertTrue((tree != null ? 1 : 0) != 0);
            PennTreeReaderTest.assertEquals((String)expected[i], (String)tree.toString());
        }
        Tree tree = treeReader.readTree();
        PennTreeReaderTest.assertFalse((tree != null ? 1 : 0) != 0);
    }
}

