/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.pennchinese.CTBErrorCorrectingTreeNormalizer;
import junit.framework.TestCase;

public class CTBErrorCorrectingTreeNormalizerTest
extends TestCase {
    public void testNormalDelete() {
        String input = "(ROOT (IP (FLR (PU \u3008) (VV \uff54\uff55\uff52\uff4e) (PU \u3009)) (PP (ADVP (AD \u5c31)) (PP (P \u5728) (NP (CP (IP (NP (NR \u5317\u97e9)) (VP (DVP (VP (VA \u79ef\u6781)) (DEV \u7684)) (VP (VV \u8d70\u5411) (NP (NN \u56fd\u9645) (NN \u793e\u4f1a))))) (DEC \u7684)) (NP (NN \u540c\u65f6))))) (PU \uff0c) (NP (CP (IP (VP (ADVP (AD \u521a\u521a)) (VP (VV \u6e21\u8fc7) (NP (QP (CD \u4e00) (CLP (M \u573a))) (NP (NN \u5927\u9009) (NN \u5371\u673a)))))) (DEC \u7684)) (NP (NR \u5357\u65af\u62c9\u592b))) (VP (ADVP (AD \u4e5f)) (ADVP (AD \u5728)) (VP (VV \u5bfb\u6c42) (NP (DNP (LCP (NP (NN \u56fd\u9645)) (LC \u95f4)) (DEG \u7684)) (NP (NN \u534f\u52a9))))) (PU \u3002)))";
        String output = "(ROOT (IP (PP (ADVP (AD \u5c31)) (PP (P \u5728) (NP (CP (IP (NP (NR \u5317\u97e9)) (VP (DVP (VP (VA \u79ef\u6781)) (DEV \u7684)) (VP (VV \u8d70\u5411) (NP (NN \u56fd\u9645) (NN \u793e\u4f1a))))) (DEC \u7684)) (NP (NN \u540c\u65f6))))) (PU \uff0c) (NP (CP (IP (VP (ADVP (AD \u521a\u521a)) (VP (VV \u6e21\u8fc7) (NP (QP (CD \u4e00) (CLP (M \u573a))) (NP (NN \u5927\u9009) (NN \u5371\u673a)))))) (DEC \u7684)) (NP (NR \u5357\u65af\u62c9\u592b))) (VP (ADVP (AD \u4e5f)) (ADVP (AD \u5728)) (VP (VV \u5bfb\u6c42) (NP (DNP (LCP (NP (NN \u56fd\u9645)) (LC \u95f4)) (DEG \u7684)) (NP (NN \u534f\u52a9))))) (PU \u3002)))";
        CTBErrorCorrectingTreeNormalizerTest.runTest(input, output);
    }

    public void testFixSplitElement() {
        String input = "(ROOT (IP (IP (NP (NN \u4e0b\u9762)) (VP (VV \u8bf7) (VP (VV \u542c) (NP (DNP (NP (NN \u62a5\u9053)) (DEG \u7684)) (ADJP (JJ \u8be6\u7ec6)) (NP (NN \u5185\u5bb9)))))) (PU \uff1a) (FLR (PU \u3008)) (VV \uff54\uff55\uff52\uff4e) (PU \u3009) (IP (NP (NP (NP (NR \u6cd5\u56fd)) (NP (NN \u5916\u4ea4) (NN \u90e8\u957f))) (NP (NR \u97e6\u91cc\u5fb7\u7eb3))) (PU \uff0c) (VP (VC \u662f) (NP (PP (P \u81ea\u4ece) (LCP (IP (NP (NT \u53bb\u5e74)) (NP (NR \u5317\u7ea6)) (VP (VV \u8f70\u70b8) (NP (NR \u5357\u65af\u62c9\u592b)))) (LC \u4ee5\u6765))) (PU \uff0c) (QP (OD \u7b2c\u4e00) (CLP (M \u4f4d))) (CP (IP (VP (VV \u8bbf\u95ee) (NP (NP (NR \u5357\u65af\u62c9\u592b)) (NP (NN \u9996\u90fd))))) (DEC \u7684)) (ADJP (JJ \u4e3b\u8981)) (NP (NN \u897f\u65b9) (NN \u56fd\u5bb6) (NN \u5916\u4ea4\u5b98))))) (PU \u3002)))";
        String output = "(ROOT (IP (IP (NP (NN \u4e0b\u9762)) (VP (VV \u8bf7) (VP (VV \u542c) (NP (DNP (NP (NN \u62a5\u9053)) (DEG \u7684)) (ADJP (JJ \u8be6\u7ec6)) (NP (NN \u5185\u5bb9)))))) (PU \uff1a) (IP (NP (NP (NP (NR \u6cd5\u56fd)) (NP (NN \u5916\u4ea4) (NN \u90e8\u957f))) (NP (NR \u97e6\u91cc\u5fb7\u7eb3))) (PU \uff0c) (VP (VC \u662f) (NP (PP (P \u81ea\u4ece) (LCP (IP (NP (NT \u53bb\u5e74)) (NP (NR \u5317\u7ea6)) (VP (VV \u8f70\u70b8) (NP (NR \u5357\u65af\u62c9\u592b)))) (LC \u4ee5\u6765))) (PU \uff0c) (QP (OD \u7b2c\u4e00) (CLP (M \u4f4d))) (CP (IP (VP (VV \u8bbf\u95ee) (NP (NP (NR \u5357\u65af\u62c9\u592b)) (NP (NN \u9996\u90fd))))) (DEC \u7684)) (ADJP (JJ \u4e3b\u8981)) (NP (NN \u897f\u65b9) (NN \u56fd\u5bb6) (NN \u5916\u4ea4\u5b98))))) (PU \u3002)))";
        CTBErrorCorrectingTreeNormalizerTest.runTest(input, output);
    }

    public void testAnotherSplit() {
        String input = "(ROOT (IP (LCP (IP (FLR (PU \uff1c) (NR \uff25\uff4e\uff47\uff4c\uff49\uff53\uff48) (PU \uff1e)) (NP (NP (NR \uff21\uff30\uff25\uff23) (PU \uff1c)) (FLR (PU \uff0f) (NT \uff25\uff4e\uff47\uff4c\uff49\uff53\uff48) (PU \uff1e)) (NP (NN \u4f1a\u8bae))) (VP (VV \u4e3e\u884c))) (LC \u524d)) (PU \uff0c) (NP (NP (NP (NR \u65e5\u672c)) (NP (NN \u9996\u76f8))) (NP (NR \u5c0f\u6cc9\u7eaf\u4e00\u90ce))) (VP (VP (QP (OD \u7b2c\u4e94) (CLP (M \u5ea6))) (VP (VV \u53c2\u62dc) (NP (NN \u9756\u56fd\u795e\u793e)))) (PU \uff0c) (VP (VV \u53d7\u5230) (IP (NP (NP (NR \u4e2d) (NR \u97e9) (ETC \u7b49)) (NP (NR \u4e9a\u6d32)) (NP (NN \u56fd\u5bb6))) (VP (ADJP (AD \u4e25\u5389)) (VP (VV \u8c34\u8d23)))))) (PU \u3002)))";
        String output = "(ROOT (IP (LCP (IP (NP (NP (NR \uff21\uff30\uff25\uff23)) (NP (NN \u4f1a\u8bae))) (VP (VV \u4e3e\u884c))) (LC \u524d)) (PU \uff0c) (NP (NP (NP (NR \u65e5\u672c)) (NP (NN \u9996\u76f8))) (NP (NR \u5c0f\u6cc9\u7eaf\u4e00\u90ce))) (VP (VP (QP (OD \u7b2c\u4e94) (CLP (M \u5ea6))) (VP (VV \u53c2\u62dc) (NP (NN \u9756\u56fd\u795e\u793e)))) (PU \uff0c) (VP (VV \u53d7\u5230) (IP (NP (NP (NR \u4e2d) (NR \u97e9) (ETC \u7b49)) (NP (NR \u4e9a\u6d32)) (NP (NN \u56fd\u5bb6))) (VP (ADJP (AD \u4e25\u5389)) (VP (VV \u8c34\u8d23)))))) (PU \u3002)))";
        CTBErrorCorrectingTreeNormalizerTest.runTest(input, output);
    }

    public void testNothingLeftTree() {
        String input = "( (FLR (PU \uff1c) (VA \uff46\uff4f\uff52\uff45\uff49\uff47\uff4e) (PU \uff1e) (PU \uff08) (PU \uff08) (PU \uff09) (PU \uff09) (PU \uff1c) (PU \uff0f) (VA \uff46\uff4f\uff52\uff45\uff49\uff47\uff4e) (PU \uff1e)))";
        CTBErrorCorrectingTreeNormalizerTest.runTest(input, null);
    }

    private static void runTest(String input, String output) {
        Tree inputTree = Tree.valueOf(input);
        CTBErrorCorrectingTreeNormalizer tt = new CTBErrorCorrectingTreeNormalizer(false, false, false, false);
        Tree outputTree = tt.apply(inputTree);
        if (output == null) {
            CTBErrorCorrectingTreeNormalizerTest.assertNull((Object)outputTree);
        } else {
            CTBErrorCorrectingTreeNormalizerTest.assertEquals((String)output, (String)outputTree.toString());
        }
    }
}

