/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import java.util.regex.Matcher;
import junit.framework.TestCase;

public class AuxiliaryTreeTest
extends TestCase {
    public void testNamePattern() {
        AuxiliaryTreeTest.runNamePatternTrue("abcd=efgh", "abcd", "efgh");
        AuxiliaryTreeTest.runNamePatternFalse("abcd\\=efgh");
        AuxiliaryTreeTest.runNamePatternTrue("abcd\\\\=efgh", "abcd\\\\", "efgh");
        AuxiliaryTreeTest.runNamePatternFalse("abcd\\\\\\=efgh");
        AuxiliaryTreeTest.runNamePatternTrue("abcd\\\\\\\\=efgh", "abcd\\\\\\\\", "efgh");
    }

    public static void runNamePatternFalse(String input) {
        Matcher m = AuxiliaryTree.namePattern.matcher(input);
        AuxiliaryTreeTest.assertFalse((boolean)m.find());
    }

    public static void runNamePatternTrue(String input, String leftover, String name) {
        Matcher m = AuxiliaryTree.namePattern.matcher(input);
        AuxiliaryTreeTest.assertTrue((boolean)m.find());
        AuxiliaryTreeTest.assertEquals((String)leftover, (String)m.group(1));
        AuxiliaryTreeTest.assertEquals((String)name, (String)m.group(2));
    }

    public void testUnescape() {
        AuxiliaryTreeTest.assertEquals((String)"asdf", (String)AuxiliaryTree.unescape("asdf"));
        AuxiliaryTreeTest.assertEquals((String)"asdf=", (String)AuxiliaryTree.unescape("asdf\\="));
        AuxiliaryTreeTest.assertEquals((String)"asdf\\=", (String)AuxiliaryTree.unescape("asdf\\\\="));
    }
}

