/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.truecaser;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;

public class MixDisambiguation {
    private static Map<String, Counter<String>> map = Generics.newHashMap();
    private static Map<String, String> highest = Generics.newHashMap();

    private MixDisambiguation() {
    }

    public static void main(String[] args) throws IOException {
        boolean outputLowercase = true;
        for (String arg : args) {
            String line;
            if (arg.equalsIgnoreCase("-noLowercase")) {
                outputLowercase = false;
                continue;
            }
            BufferedReader in = new BufferedReader(new FileReader(arg));
            while ((line = in.readLine()) != null) {
                String[] toks;
                for (String tok : toks = line.split(" ")) {
                    String lctok = tok.toLowerCase();
                    Counter<String> counter = map.get(lctok);
                    if (counter == null) {
                        counter = new ClassicCounter<String>();
                        map.put(lctok, counter);
                    }
                    counter.incrementCount(tok);
                }
            }
        }
        for (String k : map.keySet()) {
            Counter<String> counter = map.get(k);
            String maxstr = "";
            int maxcount = -1;
            for (String str : counter.keySet()) {
                int count = (int)counter.getCount(str);
                if (count <= maxcount) continue;
                maxstr = str;
                maxcount = count;
            }
            highest.put(k, maxstr);
        }
        for (String k : highest.keySet()) {
            String cased = highest.get(k);
            if (!outputLowercase && k.equals(cased)) continue;
            System.out.printf("%s\t%s\n", k, cased);
        }
    }
}

