/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArgumentParser;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArgumentParserTest {
    @Before
    public void setUp() {
        StaticClass.staticOption = -1;
        MixedClass.staticOption = -1;
    }

    @Test
    public void testFillStaticField() {
        Assert.assertEquals((long)-1L, (long)StaticClass.staticOption);
        ArgumentParser.fillOptions(StaticClass.class, "-option.static", "42");
        Assert.assertEquals((long)42L, (long)StaticClass.staticOption);
    }

    @Test
    public void testFillStaticFieldFromProperties() {
        Assert.assertEquals((long)-1L, (long)StaticClass.staticOption);
        Properties props = new Properties();
        props.setProperty("option.static", "42");
        ArgumentParser.fillOptions(StaticClass.class, props);
        Assert.assertEquals((long)42L, (long)StaticClass.staticOption);
    }

    @Test
    public void fillNonstaticField() {
        NonstaticClass x = new NonstaticClass();
        Assert.assertEquals((long)-1L, (long)x.staticOption);
        ArgumentParser.fillOptions((Object)x, new String[]{"-option.nonstatic", "42"});
        Assert.assertEquals((long)42L, (long)x.staticOption);
    }

    @Test
    public void fillNonstaticFieldFromProperties() {
        NonstaticClass x = new NonstaticClass();
        Assert.assertEquals((long)-1L, (long)x.staticOption);
        Properties props = new Properties();
        props.setProperty("option.nonstatic", "42");
        ArgumentParser.fillOptions((Object)x, props);
        Assert.assertEquals((long)42L, (long)x.staticOption);
    }

    @Test
    public void fillMixedFieldsInstanceGiven() {
        MixedClass x = new MixedClass();
        Assert.assertEquals((long)-1L, (long)MixedClass.staticOption);
        Assert.assertEquals((long)-1L, (long)x.nonstaticOption);
        ArgumentParser.fillOptions((Object)x, new String[]{"-option.nonstatic", "42", "-option.static", "43"});
        Assert.assertEquals((long)43L, (long)MixedClass.staticOption);
        Assert.assertEquals((long)42L, (long)x.nonstaticOption);
    }

    @Test
    public void fillMixedFieldsNoInstanceGiven() {
        MixedClass x = new MixedClass();
        Assert.assertEquals((long)-1L, (long)MixedClass.staticOption);
        Assert.assertEquals((long)-1L, (long)x.nonstaticOption);
        ArgumentParser.fillOptions(MixedClass.class, "-option.nonstatic", "42", "-option.static", "43");
        Assert.assertEquals((long)43L, (long)MixedClass.staticOption);
        Assert.assertEquals((long)-1L, (long)x.nonstaticOption);
    }

    public static class MixedClass {
        @ArgumentParser.Option(name="option.static")
        public static int staticOption = -1;
        @ArgumentParser.Option(name="option.nonstatic")
        public int nonstaticOption = -1;
    }

    public static class NonstaticClass {
        @ArgumentParser.Option(name="option.nonstatic")
        public int staticOption = -1;
    }

    public static class StaticClass {
        @ArgumentParser.Option(name="option.static")
        public static int staticOption = -1;
    }
}

