/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.ArrayCoreMap;
import java.util.ArrayList;
import junit.framework.TestCase;

public class ArrayCoreMapTest
extends TestCase {
    public void testCreate() {
        ArrayCoreMap foo = new ArrayCoreMap();
        ArrayCoreMapTest.assertEquals((int)0, (int)foo.size());
    }

    public void testGetAndSet() {
        ArrayCoreMap foo = new ArrayCoreMap();
        ArrayCoreMapTest.assertEquals((int)0, (int)foo.size());
        foo.set(CoreAnnotations.TextAnnotation.class, "foo");
        ArrayCoreMapTest.assertEquals((String)"foo", (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        ArrayCoreMapTest.assertEquals(null, foo.get(CoreAnnotations.ParagraphsAnnotation.class));
        ArrayCoreMapTest.assertEquals((int)1, (int)foo.size());
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "F");
        ArrayCoreMapTest.assertEquals((String)"foo", (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals((String)"F", (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        ArrayCoreMapTest.assertEquals(null, foo.get(CoreAnnotations.ParagraphsAnnotation.class));
        ArrayCoreMapTest.assertEquals((int)2, (int)foo.size());
        ArrayList<ArrayCoreMap> paragraphs = new ArrayList<ArrayCoreMap>();
        ArrayCoreMap f1 = new ArrayCoreMap();
        f1.set(CoreAnnotations.TextAnnotation.class, "f");
        paragraphs.add(f1);
        ArrayCoreMap f2 = new ArrayCoreMap();
        f2.set(CoreAnnotations.TextAnnotation.class, "o");
        paragraphs.add(f2);
        foo.set(CoreAnnotations.ParagraphsAnnotation.class, paragraphs);
        ArrayCoreMapTest.assertEquals((String)"foo", (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals((String)"F", (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        ArrayCoreMapTest.assertEquals((int)3, (int)foo.size());
    }

    public void testSimpleEquals() {
        ArrayCoreMap foo = new ArrayCoreMap();
        ArrayList<ArrayCoreMap> paragraphs = new ArrayList<ArrayCoreMap>();
        ArrayCoreMap f1 = new ArrayCoreMap();
        f1.set(CoreAnnotations.TextAnnotation.class, "f");
        paragraphs.add(f1);
        ArrayCoreMap f2 = new ArrayCoreMap();
        f2.set(CoreAnnotations.TextAnnotation.class, "o");
        paragraphs.add(f2);
        foo.set(CoreAnnotations.ParagraphsAnnotation.class, paragraphs);
        ArrayCoreMap bar = new ArrayCoreMap();
        bar.set(CoreAnnotations.ParagraphsAnnotation.class, paragraphs);
        ArrayCoreMapTest.assertEquals((Object)foo, (Object)bar);
        ArrayCoreMapTest.assertEquals((Object)bar, (Object)foo);
        ArrayCoreMapTest.assertFalse((boolean)foo.equals((Object)f1));
        ArrayCoreMapTest.assertFalse((boolean)foo.equals((Object)f2));
        ArrayCoreMapTest.assertEquals((Object)f1, (Object)f1);
        ArrayCoreMapTest.assertFalse((boolean)f1.equals((Object)f2));
    }

    public void testKeySet() {
        ArrayCoreMap foo = new ArrayCoreMap();
        foo.set(CoreAnnotations.TextAnnotation.class, "foo");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "NN");
        foo.set(CoreAnnotations.DocIDAnnotation.class, null);
        ArrayCoreMapTest.assertTrue((boolean)foo.keySet().contains(CoreAnnotations.TextAnnotation.class));
        ArrayCoreMapTest.assertTrue((boolean)foo.keySet().contains(CoreAnnotations.PartOfSpeechAnnotation.class));
        ArrayCoreMapTest.assertTrue((boolean)foo.keySet().contains(CoreAnnotations.DocIDAnnotation.class));
        ArrayCoreMapTest.assertFalse((boolean)foo.keySet().contains(CoreAnnotations.TokensAnnotation.class));
    }

    public void testNoHanging() {
        ArrayCoreMap foo = new ArrayCoreMap();
        ArrayList<ArrayCoreMap> paragraphs = new ArrayList<ArrayCoreMap>();
        ArrayCoreMap f1 = new ArrayCoreMap();
        f1.set(CoreAnnotations.TextAnnotation.class, "f");
        paragraphs.add(f1);
        ArrayCoreMap f2 = new ArrayCoreMap();
        f2.set(CoreAnnotations.TextAnnotation.class, "o");
        paragraphs.add(f2);
        foo.set(CoreAnnotations.ParagraphsAnnotation.class, paragraphs);
        foo.toString();
        foo.hashCode();
    }

    public void testRemove() {
        ArrayCoreMap foo = new ArrayCoreMap();
        foo.set(CoreAnnotations.TextAnnotation.class, "foo");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "F");
        ArrayCoreMapTest.assertEquals((String)"foo", (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals((String)"F", (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        ArrayCoreMapTest.assertEquals((int)2, (int)foo.size());
        foo.remove(CoreAnnotations.TextAnnotation.class);
        ArrayCoreMapTest.assertEquals((int)1, (int)foo.size());
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals((String)"F", (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        foo.set(CoreAnnotations.TextAnnotation.class, "bar");
        ArrayCoreMapTest.assertEquals((String)"bar", (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals((String)"F", (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        ArrayCoreMapTest.assertEquals((int)2, (int)foo.size());
        foo.remove(CoreAnnotations.TextAnnotation.class);
        ArrayCoreMapTest.assertEquals((int)1, (int)foo.size());
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals((String)"F", (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        foo.remove(CoreAnnotations.PartOfSpeechAnnotation.class);
        ArrayCoreMapTest.assertEquals((int)0, (int)foo.size());
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        foo.remove(CoreAnnotations.PartOfSpeechAnnotation.class);
        ArrayCoreMapTest.assertEquals((int)0, (int)foo.size());
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        ArrayCoreMap bar = new ArrayCoreMap();
        ArrayCoreMapTest.assertEquals((Object)foo, (Object)bar);
        foo.set(CoreAnnotations.TextAnnotation.class, "foo");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "F");
        bar.set(CoreAnnotations.TextAnnotation.class, "foo");
        ArrayCoreMapTest.assertFalse((boolean)foo.equals((Object)bar));
        foo.remove(CoreAnnotations.PartOfSpeechAnnotation.class);
        ArrayCoreMapTest.assertEquals((Object)foo, (Object)bar);
        ArrayCoreMapTest.assertEquals((int)1, (int)foo.size());
        foo.remove(CoreAnnotations.PartOfSpeechAnnotation.class);
        ArrayCoreMapTest.assertEquals((int)1, (int)foo.size());
        ArrayCoreMapTest.assertEquals((String)"foo", (String)((String)foo.get(CoreAnnotations.TextAnnotation.class)));
        ArrayCoreMapTest.assertEquals(null, (String)((String)foo.get(CoreAnnotations.PartOfSpeechAnnotation.class)));
    }

    public void testToShortString() {
        ArrayCoreMap foo = new ArrayCoreMap();
        foo.set(CoreAnnotations.TextAnnotation.class, "word");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "NN");
        ArrayCoreMapTest.assertEquals((String)"word/NN", (String)foo.toShortString("Text", "PartOfSpeech"));
        ArrayCoreMapTest.assertEquals((String)"NN", (String)foo.toShortString("PartOfSpeech"));
        ArrayCoreMapTest.assertEquals((String)"", (String)foo.toShortString("Lemma"));
        ArrayCoreMapTest.assertEquals((String)"word|NN", (String)foo.toShortString('|', "Text", "PartOfSpeech", "Lemma"));
        foo.set(CoreAnnotations.AntecedentAnnotation.class, "the price of tea");
        ArrayCoreMapTest.assertEquals((String)"{word/NN/the price of tea}", (String)foo.toShortString("Text", "PartOfSpeech", "Antecedent"));
    }

    public void testEqualsReversedInsertOrder() {
        ArrayCoreMap foo = new ArrayCoreMap();
        ArrayList<ArrayCoreMap> paragraphs = new ArrayList<ArrayCoreMap>();
        ArrayCoreMap f1 = new ArrayCoreMap();
        f1.set(CoreAnnotations.TextAnnotation.class, "f");
        paragraphs.add(f1);
        ArrayCoreMap f2 = new ArrayCoreMap();
        f2.set(CoreAnnotations.TextAnnotation.class, "o");
        paragraphs.add(f2);
        foo.set(CoreAnnotations.ParagraphsAnnotation.class, paragraphs);
        foo.set(CoreAnnotations.TextAnnotation.class, "A");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        ArrayCoreMap bar = new ArrayCoreMap();
        ArrayList paragraphs2 = new ArrayList(paragraphs);
        bar.set(CoreAnnotations.TextAnnotation.class, "A");
        bar.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        bar.set(CoreAnnotations.ParagraphsAnnotation.class, paragraphs2);
        ArrayCoreMapTest.assertEquals((Object)foo, (Object)bar);
        ArrayCoreMapTest.assertEquals((Object)bar, (Object)foo);
        ArrayCoreMapTest.assertFalse((boolean)foo.equals((Object)f1));
        ArrayCoreMapTest.assertFalse((boolean)foo.equals((Object)f2));
        ArrayCoreMapTest.assertEquals((int)3, (int)foo.size());
    }

    public void testObjectLoops() {
        ArrayCoreMap foo = new ArrayCoreMap();
        foo.set(CoreAnnotations.TextAnnotation.class, "foo");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        ArrayList<ArrayCoreMap> fooParagraph = new ArrayList<ArrayCoreMap>();
        fooParagraph.add(foo);
        ArrayCoreMap f1 = new ArrayCoreMap();
        f1.set(CoreAnnotations.ParagraphsAnnotation.class, fooParagraph);
        ArrayList<ArrayCoreMap> p1 = new ArrayList<ArrayCoreMap>();
        p1.add(f1);
        foo.set(CoreAnnotations.ParagraphsAnnotation.class, p1);
        foo.toString();
        foo.hashCode();
    }

    public void testObjectLoopEquals() {
        ArrayCoreMap foo = new ArrayCoreMap();
        foo.set(CoreAnnotations.TextAnnotation.class, "foo");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        ArrayList<ArrayCoreMap> fooParagraph = new ArrayList<ArrayCoreMap>();
        fooParagraph.add(foo);
        ArrayCoreMap f1 = new ArrayCoreMap();
        f1.set(CoreAnnotations.ParagraphsAnnotation.class, fooParagraph);
        ArrayList<ArrayCoreMap> p1 = new ArrayList<ArrayCoreMap>();
        p1.add(f1);
        foo.set(CoreAnnotations.ParagraphsAnnotation.class, p1);
        foo.toString();
        int fh = foo.hashCode();
        ArrayCoreMap bar = new ArrayCoreMap();
        bar.set(CoreAnnotations.TextAnnotation.class, "foo");
        bar.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        ArrayList<ArrayCoreMap> barParagraph = new ArrayList<ArrayCoreMap>();
        barParagraph.add(bar);
        ArrayCoreMap f2 = new ArrayCoreMap();
        f2.set(CoreAnnotations.ParagraphsAnnotation.class, barParagraph);
        ArrayList<ArrayCoreMap> p2 = new ArrayList<ArrayCoreMap>();
        p2.add(f2);
        bar.set(CoreAnnotations.ParagraphsAnnotation.class, p2);
        bar.toString();
        int bh = bar.hashCode();
        ArrayCoreMapTest.assertEquals((Object)foo, (Object)bar);
        ArrayCoreMapTest.assertEquals((Object)bar, (Object)foo);
        ArrayCoreMapTest.assertEquals((int)fh, (int)bh);
        ArrayCoreMap baz = new ArrayCoreMap();
        baz.set(CoreAnnotations.TextAnnotation.class, "foo");
        baz.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        ArrayList<ArrayCoreMap> foobarParagraph = new ArrayList<ArrayCoreMap>();
        foobarParagraph.add(foo);
        foobarParagraph.add(bar);
        ArrayCoreMap f3 = new ArrayCoreMap();
        f3.set(CoreAnnotations.ParagraphsAnnotation.class, foobarParagraph);
        ArrayList<ArrayCoreMap> p3 = new ArrayList<ArrayCoreMap>();
        p3.add(f3);
        baz.set(CoreAnnotations.ParagraphsAnnotation.class, p3);
        ArrayCoreMapTest.assertFalse((boolean)foo.equals((Object)baz));
        ArrayCoreMapTest.assertFalse((boolean)baz.equals((Object)foo));
        ArrayCoreMap biff = new ArrayCoreMap();
        biff.set(CoreAnnotations.TextAnnotation.class, "foo");
        biff.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        ArrayList<ArrayCoreMap> barfooParagraph = new ArrayList<ArrayCoreMap>();
        barfooParagraph.add(foo);
        barfooParagraph.add(bar);
        ArrayCoreMap f4 = new ArrayCoreMap();
        f4.set(CoreAnnotations.ParagraphsAnnotation.class, barfooParagraph);
        ArrayList<ArrayCoreMap> p4 = new ArrayList<ArrayCoreMap>();
        p4.add(f4);
        biff.set(CoreAnnotations.ParagraphsAnnotation.class, p4);
        ArrayCoreMapTest.assertEquals((Object)baz, (Object)biff);
        barfooParagraph.clear();
        ArrayCoreMapTest.assertFalse((boolean)baz.equals((Object)biff));
        barfooParagraph.add(foo);
        ArrayCoreMapTest.assertFalse((boolean)baz.equals((Object)biff));
        barfooParagraph.add(baz);
        ArrayCoreMapTest.assertFalse((boolean)baz.equals((Object)biff));
        barfooParagraph.clear();
        ArrayCoreMapTest.assertFalse((boolean)baz.equals((Object)biff));
        barfooParagraph.add(foo);
        barfooParagraph.add(bar);
        ArrayCoreMapTest.assertEquals((Object)baz, (Object)biff);
    }

    public void testCoreLabelSetWordBehavior() {
        CoreLabel foo = new CoreLabel();
        foo.set(CoreAnnotations.TextAnnotation.class, "foo");
        foo.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        foo.set(CoreAnnotations.LemmaAnnotation.class, "fool");
        ArrayCoreMap copy = new ArrayCoreMap(foo);
        ArrayCoreMapTest.assertEquals((Object)copy, (Object)foo);
        foo.setWord("foo");
        ArrayCoreMapTest.assertEquals((Object)copy, (Object)foo);
        foo.setWord("bar");
        ArrayCoreMapTest.assertFalse((boolean)copy.equals((Object)foo));
        foo.setWord("foo");
        ArrayCoreMapTest.assertFalse((boolean)copy.equals((Object)foo));
        foo.set(CoreAnnotations.LemmaAnnotation.class, "fool");
        ArrayCoreMapTest.assertEquals((Object)copy, (Object)foo);
        int hashCode = foo.hashCode();
        ArrayCoreMapTest.assertEquals((int)copy.hashCode(), (int)hashCode);
        foo.setWord("bar");
        ArrayCoreMapTest.assertFalse((hashCode == foo.hashCode() ? 1 : 0) != 0);
        foo.setWord("foo");
        ArrayCoreMapTest.assertFalse((hashCode == foo.hashCode() ? 1 : 0) != 0);
        ArrayCoreMapTest.assertTrue((foo.lemma() == null ? 1 : 0) != 0);
        int lemmalessHashCode = foo.hashCode();
        foo.remove(CoreAnnotations.LemmaAnnotation.class);
        ArrayCoreMapTest.assertEquals((int)lemmalessHashCode, (int)foo.hashCode());
        foo.setLemma(null);
        ArrayCoreMapTest.assertEquals((int)lemmalessHashCode, (int)foo.hashCode());
        foo.setLemma("fool");
        ArrayCoreMapTest.assertEquals((int)hashCode, (int)foo.hashCode());
        foo.setWord("bar");
        foo.setWord("foo");
        ArrayCoreMap nulledCopy = new ArrayCoreMap(foo);
        ArrayCoreMapTest.assertEquals((Object)nulledCopy, (Object)foo);
        foo.remove(CoreAnnotations.LemmaAnnotation.class);
        ArrayCoreMapTest.assertEquals((Object)nulledCopy, (Object)foo);
    }

    public void testCopyConstructor() {
        ArrayCoreMap biff = new ArrayCoreMap();
        biff.set(CoreAnnotations.TextAnnotation.class, "foo");
        biff.set(CoreAnnotations.PartOfSpeechAnnotation.class, "B");
        biff.set(CoreAnnotations.LemmaAnnotation.class, "fozzle");
        ArrayCoreMap boff = new ArrayCoreMap(biff);
        ArrayCoreMapTest.assertEquals((int)3, (int)boff.size());
        ArrayCoreMapTest.assertEquals((Object)biff, (Object)boff);
        ArrayCoreMapTest.assertEquals((String)"fozzle", (String)((String)boff.get(CoreAnnotations.LemmaAnnotation.class)));
    }
}

