/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayUtils;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ArrayUtilsTest
extends TestCase {
    int[] sampleGaps = new int[]{1, 5, 6, 10, 17, 22, 29, 33, 100, 1000, 10000, 9999999};
    int[] sampleBadGaps = new int[]{1, 6, 5, 10, 17};

    public void testEqualContentsInt() {
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.equalContents(this.sampleGaps, this.sampleGaps));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.equalContents(this.sampleBadGaps, this.sampleBadGaps));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.equalContents(this.sampleGaps, this.sampleBadGaps));
    }

    public void testGaps() {
        byte[] encoded = ArrayUtils.gapEncode(this.sampleGaps);
        int[] decoded = ArrayUtils.gapDecode(encoded);
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.equalContents(decoded, this.sampleGaps));
        try {
            ArrayUtils.gapEncode(this.sampleBadGaps);
            throw new RuntimeException("Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void testDelta() {
        byte[] encoded = ArrayUtils.deltaEncode(this.sampleGaps);
        int[] decoded = ArrayUtils.deltaDecode(encoded);
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.equalContents(decoded, this.sampleGaps));
        try {
            ArrayUtils.deltaEncode(this.sampleBadGaps);
            throw new RuntimeException("Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void testRemoveAt() {
        Object[] strings = new String[]{"a", "b", "c"};
        strings = (String[])ArrayUtils.removeAt(strings, 2);
        int i = 0;
        for (Object string : strings) {
            if (i == 0) {
                ArrayUtilsTest.assertEquals((String)"a", (String)string);
            } else if (i == 1) {
                ArrayUtilsTest.assertEquals((String)"b", (String)string);
            } else {
                ArrayUtilsTest.fail((String)"Array is too big!");
            }
            ++i;
        }
    }

    public void testAsSet() {
        String[] items = new String[]{"larry", "moe", "curly"};
        HashSet<String> set = new HashSet<String>(Arrays.asList(items));
        ArrayUtilsTest.assertEquals(set, ArrayUtils.asSet(items));
    }

    public void testgetSubListIndex() {
        Object[] t1 = new String[]{"this", "is", "test"};
        Object[] t2 = new String[]{"well", "this", "is", "not", "this", "is", "test", "also"};
        Assert.assertEquals((int)4, (int)ArrayUtils.getSubListIndex(t1, t2).get(0));
        Object[] t3 = new String[]{"cough", "increased"};
        Object[] t4 = new String[]{"i", "dont", "really", "cough"};
        Assert.assertEquals((int)0, (int)ArrayUtils.getSubListIndex(t3, t4).size());
        Object[] t5 = new String[]{"cough", "increased"};
        Object[] t6 = new String[]{"cough", "aggravated"};
        Assert.assertEquals((int)0, (int)ArrayUtils.getSubListIndex(t5, t6).size());
        Object[] t7 = new String[]{"cough", "increased"};
        Object[] t8 = new String[]{"cough", "aggravated", "cough", "increased", "and", "cough", "increased", "and", "cough", "and", "increased"};
        Assert.assertEquals((int)2, (int)ArrayUtils.getSubListIndex(t7, t8).get(0));
        Assert.assertEquals((int)5, (int)ArrayUtils.getSubListIndex(t7, t8).get(1));
    }
}

