/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.Comparator;
import java.util.TreeSet;

public class BoundedPriorityQueue<E>
extends TreeSet<E> {
    private int remainingCapacity;
    private int initialCapacity;

    public BoundedPriorityQueue(int maxSize) {
        this.initialCapacity = maxSize;
        this.remainingCapacity = maxSize;
    }

    public BoundedPriorityQueue(int maxSize, Comparator<E> comparator) {
        super(comparator);
        this.initialCapacity = maxSize;
        this.remainingCapacity = maxSize;
    }

    @Override
    public void clear() {
        super.clear();
        this.remainingCapacity = this.initialCapacity;
    }

    @Override
    public boolean add(E e) {
        if (this.remainingCapacity == 0 && this.size() == 0) {
            return false;
        }
        if (this.remainingCapacity > 0) {
            boolean added = super.add(e);
            if (added) {
                --this.remainingCapacity;
            }
            return added;
        }
        int compared = super.comparator().compare(e, this.first());
        if (compared == 1) {
            this.pollFirst();
            super.add(e);
            return true;
        }
        return false;
    }
}

