/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.util.ArrayCoreMap;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import junit.framework.TestCase;

public class CoreMapTest
extends TestCase {
    public void testCoreMap() {
        ArrayCoreMap object = new ArrayCoreMap(0);
        CoreMapTest.assertFalse((boolean)object.containsKey(StringA.class));
        object.set(StringA.class, "stem");
        CoreMapTest.assertTrue((boolean)object.containsKey(StringA.class));
        CoreMapTest.assertEquals((String)"stem", (String)((String)object.get(StringA.class)));
        object.set(StringA.class, "hi");
        CoreMapTest.assertEquals((String)"hi", (String)((String)object.get(StringA.class)));
        CoreMapTest.assertEquals(null, object.get(IntegerA.class));
        object.set(IntegerA.class, 4);
        CoreMapTest.assertEquals((Object)4, object.get(IntegerA.class));
        object.set(StringB.class, "Yes");
        CoreMapTest.assertEquals((String)"Wrong # objects", (int)3, (int)object.keySet().size());
        CoreMapTest.assertEquals((String)"Wrong keyset", new HashSet<Class>(Arrays.asList(StringA.class, IntegerA.class, StringB.class)), object.keySet());
        CoreMapTest.assertEquals((String)"Wrong remove value", (Object)4, object.remove(IntegerA.class));
        CoreMapTest.assertEquals((String)"Wrong # objects", (int)2, (int)object.keySet().size());
        CoreMapTest.assertEquals((String)"Wrong keyset", new HashSet<Class>(Arrays.asList(StringA.class, StringB.class)), object.keySet());
        CoreMapTest.assertEquals((String)"Wrong value", (String)"hi", (String)((String)object.get(StringA.class)));
        CoreMapTest.assertEquals((String)"Wrong value", (String)"Yes", (String)((String)object.get(StringB.class)));
        CoreMapTest.assertEquals(null, (Object)object.set(IntegerA.class, 7));
        CoreMapTest.assertEquals((Object)7, object.get(IntegerA.class));
        CoreMapTest.assertEquals((Object)7, (Object)object.set(IntegerA.class, 3));
        CoreMapTest.assertEquals((Object)3, object.get(IntegerA.class));
    }

    public void testToShorterString() {
        ArrayCoreMap a = new ArrayCoreMap();
        a.set(CoreAnnotations.TextAnnotation.class, "Australia");
        a.set(CoreAnnotations.NamedEntityTagAnnotation.class, "LOCATION");
        a.set(CoreAnnotations.BeforeAnnotation.class, "  ");
        a.set(CoreAnnotations.PartOfSpeechAnnotation.class, "NNP");
        a.set(CoreAnnotations.ShapeAnnotation.class, "Xx");
        CoreMapTest.assertEquals((String)"Incorrect toShorterString()", (String)"[Text=Australia NamedEntityTag=LOCATION]", (String)a.toShorterString("Text", "NamedEntityTag"));
        CoreMapTest.assertEquals((String)"Incorrect toShorterString()", (String)"[Text=Australia]", (String)a.toShorterString("Text"));
        CoreMapTest.assertEquals((String)"Incorrect toShorterString()", (String)"[Text=Australia NamedEntityTag=LOCATION Before=   PartOfSpeech=NNP Shape=Xx]", (String)a.toShorterString(new String[0]));
    }

    public void testEquality() {
        ArrayCoreMap a = new ArrayCoreMap();
        ArrayCoreMap b = new ArrayCoreMap();
        CoreMapTest.assertTrue((boolean)((Object)a).equals(b));
        CoreMapTest.assertTrue((((Object)a).hashCode() == ((Object)b).hashCode() ? 1 : 0) != 0);
        a.set(StringA.class, "hi");
        CoreMapTest.assertFalse((boolean)((Object)a).equals(b));
        CoreMapTest.assertFalse((((Object)a).hashCode() == ((Object)b).hashCode() ? 1 : 0) != 0);
        b.set(StringA.class, "hi");
        CoreMapTest.assertTrue((boolean)((Object)a).equals(b));
        CoreMapTest.assertTrue((((Object)a).hashCode() == ((Object)b).hashCode() ? 1 : 0) != 0);
        a.remove(StringA.class);
        CoreMapTest.assertFalse((boolean)((Object)a).equals(b));
        CoreMapTest.assertFalse((((Object)a).hashCode() == ((Object)b).hashCode() ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        Class[] allKeys = new Class[]{CoreAnnotations.TextAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.ShapeAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.DocIDAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.CategoryAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.ArgumentAnnotation.class, CoreAnnotations.MarkingAnnotation.class};
        int numBurnRounds = 10;
        int numGoodRounds = 60;
        int numIterations = 2000000;
        int maxNumKeys = 12;
        double gains = 0.0;
        for (int numKeys = 1; numKeys <= 12; ++numKeys) {
            HashMap<String, String> hashmap = new HashMap<String, String>(numKeys);
            ArrayCoreMap coremap = new ArrayCoreMap(numKeys);
            String[] hashKeys = new String[numKeys];
            Class[] coreKeys = new Class[numKeys];
            for (int key = 0; key < numKeys; ++key) {
                hashKeys[key] = allKeys[key].getSimpleName();
                coreKeys[key] = allKeys[key];
            }
            for (int i = 0; i < numKeys; ++i) {
                coremap.set(coreKeys[i], String.valueOf(i));
                hashmap.put(hashKeys[i], String.valueOf(i));
            }
            assert (coremap.size() == numKeys);
            assert (hashmap.size() == numKeys);
            double[] hashTimings = new double[60];
            double[] coreTimings = new double[60];
            Random rand = new Random(0L);
            boolean foundEqual = false;
            for (int round = 0; round < 70; ++round) {
                String val;
                int key;
                int i;
                String last;
                int length;
                long hashStart;
                System.err.print(".");
                if (round % 2 == 0) {
                    hashStart = System.nanoTime();
                    length = hashKeys.length;
                    last = null;
                    for (i = 0; i < 2000000; ++i) {
                        key = rand.nextInt(length);
                        val = (String)hashmap.get(hashKeys[key]);
                        if (val == last) {
                            foundEqual = true;
                        }
                        last = val;
                    }
                    if (round >= 10) {
                        hashTimings[round - 10] = (double)(System.nanoTime() - hashStart) / 1.0E9;
                    }
                }
                long coreStart = System.nanoTime();
                length = coreKeys.length;
                last = null;
                for (i = 0; i < 2000000; ++i) {
                    key = rand.nextInt(length);
                    val = (String)coremap.get(coreKeys[key]);
                    if (val == last) {
                        foundEqual = true;
                    }
                    last = val;
                }
                if (round >= 10) {
                    coreTimings[round - 10] = (double)(System.nanoTime() - coreStart) / 1.0E9;
                }
                if (round % 2 != 1) continue;
                hashStart = System.nanoTime();
                length = hashKeys.length;
                last = null;
                for (i = 0; i < 2000000; ++i) {
                    key = rand.nextInt(length);
                    val = (String)hashmap.get(hashKeys[key]);
                    if (val == last) {
                        foundEqual = true;
                    }
                    last = val;
                }
                if (round < 10) continue;
                hashTimings[round - 10] = (double)(System.nanoTime() - hashStart) / 1.0E9;
            }
            if (foundEqual) {
                System.err.print(" [found equal]");
            }
            System.err.println();
            double hashMean = ArrayMath.mean(hashTimings);
            double coreMean = ArrayMath.mean(coreTimings);
            double percentDiff = (hashMean - coreMean) / hashMean * 100.0;
            DecimalFormat nf = new DecimalFormat("0.00");
            System.out.println("HashMap @ " + numKeys + " keys: " + hashMean + " secs/2million gets");
            System.out.println("CoreMap @ " + numKeys + " keys: " + coreMean + " secs/2million gets (" + nf.format(Math.abs(percentDiff)) + "% " + (percentDiff >= 0.0 ? "faster" : "slower") + ")");
            gains += percentDiff;
        }
        System.out.println();
        System.out.println("Average: " + Math.abs(gains /= 12.0) + "% " + (gains >= 0.0 ? "faster" : "slower") + ".");
    }

    static class IntegerA
    implements CoreAnnotation<Integer> {
        IntegerA() {
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }

    private static class StringB
    implements CoreAnnotation<String> {
        private StringB() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class StringA
    implements CoreAnnotation<String> {
        private StringA() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }
}

