/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.DisjointSet;
import edu.stanford.nlp.util.Generics;
import java.util.Map;
import java.util.Set;

public class FastDisjointSet<T>
implements DisjointSet<T> {
    private Map<T, Element<T>> objectToElement = Generics.newHashMap();

    private static <TTT> void linkElements(Element<TTT> e, Element<TTT> f) {
        if (e.rank > f.rank) {
            f.parent = e;
        } else {
            e.parent = f;
            if (e.rank == f.rank) {
                ++f.rank;
            }
        }
    }

    private static <TTT> Element<TTT> findElement(Element<TTT> e) {
        if (e.parent == e) {
            return e;
        }
        Element rep = FastDisjointSet.findElement(e.parent);
        e.parent = rep;
        return rep;
    }

    @Override
    public T find(T o) {
        Element<T> e = this.objectToElement.get(o);
        if (e == null) {
            return null;
        }
        Element<T> element = FastDisjointSet.findElement(e);
        return (T)element.object;
    }

    @Override
    public void union(T a, T b) {
        Element<T> e = this.objectToElement.get(a);
        Element<T> f = this.objectToElement.get(b);
        if (e == null || f == null) {
            return;
        }
        if (e == f) {
            return;
        }
        FastDisjointSet.linkElements(FastDisjointSet.findElement(e), FastDisjointSet.findElement(f));
    }

    public FastDisjointSet(Set<? extends T> objectSet) {
        for (T o : objectSet) {
            Element<T> e = new Element<T>(o);
            this.objectToElement.put(o, e);
        }
    }

    static class Element<TT> {
        Element<TT> parent;
        int rank;
        TT object;

        Element(TT o) {
            this.object = o;
            this.rank = 0;
            this.parent = this;
        }
    }
}

