/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;

public class HashIndexTest
extends TestCase {
    protected Index<String> index;
    protected Index<String> index2;
    protected Index<String> index3;

    protected void setUp() {
        this.index = new HashIndex<String>();
        this.index.add("The");
        this.index.add("Beast");
        this.index2 = new HashIndex<String>();
        this.index2.add("Beauty");
        this.index2.add("And");
        this.index2.add("The");
        this.index2.add("Beast");
        this.index3 = new HashIndex<String>();
        this.index3.add("Markov");
        this.index3.add("The");
        this.index3.add("Beast");
    }

    public void testSize() {
        HashIndexTest.assertEquals((int)2, (int)this.index.size());
    }

    public void testGet() {
        HashIndexTest.assertEquals((int)2, (int)this.index.size());
        HashIndexTest.assertEquals((String)"The", (String)this.index.get(0));
        HashIndexTest.assertEquals((String)"Beast", (String)this.index.get(1));
    }

    public void testIndexOf() {
        HashIndexTest.assertEquals((int)2, (int)this.index.size());
        HashIndexTest.assertEquals((int)0, (int)this.index.indexOf("The"));
        HashIndexTest.assertEquals((int)1, (int)this.index.indexOf("Beast"));
    }

    public void testIterator() {
        Iterator i = this.index.iterator();
        HashIndexTest.assertEquals((String)"The", (String)((String)i.next()));
        HashIndexTest.assertEquals((String)"Beast", (String)((String)i.next()));
        HashIndexTest.assertEquals((boolean)false, (boolean)i.hasNext());
    }

    public void testToArray() {
        String[] strs = new String[2];
        strs = this.index.objectsList().toArray(strs);
        HashIndexTest.assertEquals((String)"The", (String)strs[0]);
        HashIndexTest.assertEquals((String)"Beast", (String)strs[1]);
        HashIndexTest.assertEquals((int)2, (int)strs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnmodifiableViewEtc() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("A");
        list.add("C");
        HashIndex<String> index4 = new HashIndex<String>(list);
        HashIndex<String> index5 = new HashIndex<String>();
        index5.addAll(list);
        HashIndexTest.assertEquals((String)"Equality failure", index4, index5);
        index5.addToIndex("D");
        index5.addToIndex("E");
        index5.indexOf("F");
        index5.addAll(list);
        HashIndexTest.assertEquals((int)5, (int)index5.size());
        HashIndexTest.assertEquals((int)3, (int)index4.size());
        HashIndexTest.assertTrue((boolean)index4.contains("A"));
        HashIndexTest.assertEquals((int)0, (int)index4.indexOf("A"));
        HashIndexTest.assertEquals((int)1, (int)index4.indexOf("B"));
        HashIndexTest.assertEquals((int)2, (int)index4.indexOf("C"));
        HashIndexTest.assertEquals((String)"A", (String)((String)index4.get(0)));
        HashIndex<String> index4u = index4.unmodifiableView();
        HashIndexTest.assertEquals((int)3, (int)index4u.size());
        HashIndexTest.assertTrue((boolean)index4u.contains("A"));
        HashIndexTest.assertEquals((int)0, (int)index4u.indexOf("A"));
        HashIndexTest.assertEquals((int)1, (int)index4u.indexOf("B"));
        HashIndexTest.assertEquals((int)2, (int)index4u.indexOf("C"));
        HashIndexTest.assertEquals((String)"A", (String)((String)index4u.get(0)));
        HashIndexTest.assertEquals((int)-1, (int)index4u.addToIndex("D"));
        boolean okay = false;
        try {
            index4u.unlock();
        }
        catch (UnsupportedOperationException uoe) {
            okay = true;
        }
        finally {
            HashIndexTest.assertTrue((boolean)okay);
        }
    }

    public void testCopyConstructor() {
        HashIndex<String> test = new HashIndex<String>();
        test.add("Beauty");
        test.add("And");
        test.add("The");
        test.add("Beast");
        HashIndex copy = new HashIndex(test);
        HashIndexTest.assertEquals(test, copy);
    }
}

