/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.IntervalTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

public class IntervalTreeTest
extends TestCase {
    private void checkOverlapping(Collection<Interval<Integer>> all, Collection<Interval<Integer>> overlapping, Interval<Integer> target) {
        for (Interval<Integer> interval : all) {
            IntervalTreeTest.assertNotNull(interval);
        }
        for (Interval<Integer> interval : overlapping) {
            IntervalTreeTest.assertTrue((boolean)interval.overlaps(target));
        }
        ArrayList<Interval<Integer>> rest = new ArrayList<Interval<Integer>>(all);
        rest.removeAll(overlapping);
        for (Interval interval : rest) {
            IntervalTreeTest.assertNotNull((Object)interval);
            IntervalTreeTest.assertFalse((String)("Should not overlap: " + interval + " with " + target), (boolean)interval.overlaps(target));
        }
    }

    public void testGetOverlapping() throws Exception {
        Interval<Integer> a = Interval.toInterval(249210699, 249212659);
        Interval<Integer> before = Interval.toInterval(249210000, 249210600);
        Interval<Integer> included = Interval.toInterval(249210800, 249212000);
        Interval<Integer> after = Interval.toInterval(249213000, 249214000);
        IntervalTree tree = new IntervalTree();
        tree.add(a);
        List<Interval<Integer>> overlapping1 = tree.getOverlapping(before);
        IntervalTreeTest.assertTrue((boolean)overlapping1.isEmpty());
        List<Interval<Integer>> overlapping2 = tree.getOverlapping(included);
        IntervalTreeTest.assertTrue((overlapping2.size() == 1 ? 1 : 0) != 0);
        List<Interval<Integer>> overlapping3 = tree.getOverlapping(after);
        IntervalTreeTest.assertTrue((boolean)overlapping3.isEmpty());
        tree.remove(a);
        IntervalTreeTest.assertTrue((tree.size() == 0 ? 1 : 0) != 0);
        int n = 20000;
        for (int i = 0; i < n; ++i) {
            int x = i;
            int y = i + 1;
            Interval<Integer> interval = Interval.toInterval(x, y);
            tree.add(interval);
        }
        tree.add(a);
        overlapping1 = tree.getOverlapping(before);
        IntervalTreeTest.assertTrue((boolean)overlapping1.isEmpty());
        overlapping2 = tree.getOverlapping(included);
        IntervalTreeTest.assertTrue((overlapping2.size() == 1 ? 1 : 0) != 0);
        overlapping3 = tree.getOverlapping(after);
        IntervalTreeTest.assertTrue((boolean)overlapping3.isEmpty());
        IntervalTreeTest.assertTrue((tree.height() < 20 ? 1 : 0) != 0);
        tree.check();
        tree.balance();
        int height = tree.height();
        IntervalTreeTest.assertTrue((height < 20 ? 1 : 0) != 0);
        tree.check();
        overlapping1 = tree.getOverlapping(before);
        IntervalTreeTest.assertTrue((boolean)overlapping1.isEmpty());
        overlapping2 = tree.getOverlapping(included);
        IntervalTreeTest.assertTrue((overlapping2.size() == 1 ? 1 : 0) != 0);
        overlapping3 = tree.getOverlapping(after);
        IntervalTreeTest.assertTrue((boolean)overlapping3.isEmpty());
        tree.clear();
        IntervalTreeTest.assertTrue((tree.size() == 0 ? 1 : 0) != 0);
        Random rand = new Random();
        ArrayList<Interval<Integer>> list = new ArrayList<Interval<Integer>>(n + 1);
        for (int i = 0; i < n; ++i) {
            int x = rand.nextInt();
            int y = rand.nextInt();
            Interval<Integer> interval = Interval.toValidInterval(x, y);
            tree.add(interval);
            list.add(interval);
        }
        tree.add(a);
        list.add(a);
        overlapping1 = tree.getOverlapping(before);
        this.checkOverlapping(list, overlapping1, before);
        overlapping2 = tree.getOverlapping(included);
        this.checkOverlapping(list, overlapping2, included);
        overlapping3 = tree.getOverlapping(after);
        this.checkOverlapping(list, overlapping3, after);
    }

    public void testIteratorRandom() throws Exception {
        int n = 1000;
        IntervalTree tree = new IntervalTree();
        Random rand = new Random();
        ArrayList<Interval<Integer>> list = new ArrayList<Interval<Integer>>(n + 1);
        for (int i = 0; i < n; ++i) {
            int x = rand.nextInt();
            int y = rand.nextInt();
            Interval<Integer> interval = Interval.toValidInterval(x, y);
            tree.add(interval);
            list.add(interval);
        }
        Collections.sort(list);
        Interval next = null;
        Iterator iterator = tree.iterator();
        for (int i = 0; i < list.size(); ++i) {
            IntervalTreeTest.assertTrue((String)("HasItem " + i), (boolean)iterator.hasNext());
            next = (Interval)iterator.next();
            IntervalTreeTest.assertEquals((String)("Item " + i), list.get(i), (Object)next);
        }
        IntervalTreeTest.assertFalse((String)"No more items", (boolean)iterator.hasNext());
    }

    public void testIteratorOrdered() throws Exception {
        int n = 1000;
        IntervalTree tree = new IntervalTree();
        ArrayList<Interval<Integer>> list = new ArrayList<Interval<Integer>>(n + 1);
        for (int i = 0; i < n; ++i) {
            int x = i;
            int y = i + 1;
            Interval<Integer> interval = Interval.toValidInterval(x, y);
            tree.add(interval);
            list.add(interval);
        }
        Collections.sort(list);
        Interval next = null;
        Iterator iterator = tree.iterator();
        for (int i = 0; i < list.size(); ++i) {
            IntervalTreeTest.assertTrue((String)("HasItem " + i), (boolean)iterator.hasNext());
            next = (Interval)iterator.next();
            IntervalTreeTest.assertEquals((String)("Item " + i), list.get(i), (Object)next);
        }
        IntervalTreeTest.assertFalse((String)"No more items", (boolean)iterator.hasNext());
    }
}

