/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;

public abstract class Lazy<E> {
    private SoftReference<E> implOrNullCache = null;
    private E implOrNull = null;

    void simulateGC() {
        if (this.implOrNullCache != null) {
            this.implOrNullCache.clear();
        }
    }

    public synchronized E get() {
        E orNull = this.getIfDefined();
        if (orNull == null) {
            orNull = this.compute();
            if (this.shouldGC()) {
                this.implOrNullCache = new SoftReference<E>(orNull);
            } else {
                this.implOrNull = orNull;
            }
        }
        assert (orNull != null);
        return orNull;
    }

    protected abstract E compute();

    protected abstract boolean shouldGC();

    public E getIfDefined() {
        if (this.implOrNullCache != null) {
            return this.implOrNullCache.get();
        }
        return this.implOrNull;
    }

    public static <E> Lazy<E> from(final E definedElement) {
        Lazy rtn = new Lazy<E>(){

            @Override
            protected E compute() {
                return definedElement;
            }

            @Override
            protected boolean shouldGC() {
                return false;
            }
        };
        rtn.implOrNull = definedElement;
        return rtn;
    }

    public static <E> Lazy<E> of(final Supplier<E> fn) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return fn.get();
            }

            @Override
            protected boolean shouldGC() {
                return false;
            }
        };
    }

    public static <E> Lazy<E> cache(final Supplier<E> fn) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return fn.get();
            }

            @Override
            protected boolean shouldGC() {
                return true;
            }
        };
    }
}

