/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class StringUtilsTest
extends TestCase {
    private static final char[] escapeInputs = new char[]{'\\', '\\', '\\', '\\', '\\', '\\', '\\', '\\', '\\', '\\', '\"', '\"', '\"'};
    private static final String[] csvInputs = new String[]{"", ",", "foo", "foo,bar", "foo,    bar", ",foo,bar,", "foo,\"bar\"", "\"foo,foo2\"", "1997, \"Ford\" ,E350", "foo,\"\",bar", "1999,Chevy,\"Venture \"\"Extended Edition, Large\"\"\",,5000.00", "\"\"\",foo,\"", "\"\"\"\",foo"};
    private static final String[][] csvOutputs = new String[][]{new String[0], {""}, {"foo"}, {"foo", "bar"}, {"foo", "    bar"}, {"", "foo", "bar"}, {"foo", "bar"}, {"foo,foo2"}, {"1997", " Ford ", "E350"}, {"foo", "", "bar"}, {"1999", "Chevy", "Venture \"Extended Edition, Large\"", "", "5000.00"}, {"\",foo,"}, {"\"", "foo"}};

    public void testTr() {
        StringUtilsTest.assertEquals((String)StringUtils.tr("chris", "irs", "mop"), (String)"chomp");
    }

    public void testGetBaseName() {
        StringUtilsTest.assertEquals((String)StringUtils.getBaseName("/u/wcmac/foo.txt"), (String)"foo.txt");
        StringUtilsTest.assertEquals((String)StringUtils.getBaseName("/u/wcmac/foo.txt", ""), (String)"foo.txt");
        StringUtilsTest.assertEquals((String)StringUtils.getBaseName("/u/wcmac/foo.txt", ".txt"), (String)"foo");
        StringUtilsTest.assertEquals((String)StringUtils.getBaseName("/u/wcmac/foo.txt", ".pdf"), (String)"foo.txt");
    }

    public void testArgsToProperties() {
        Properties p1 = new Properties();
        p1.setProperty("fred", "-2");
        p1.setProperty("", "joe");
        Properties p2 = new Properties();
        p2.setProperty("fred", "true");
        p2.setProperty("2", "joe");
        HashMap<String, Integer> argNums = new HashMap<String, Integer>();
        argNums.put("fred", 1);
        StringUtilsTest.assertEquals((Object)StringUtils.argsToProperties("-fred", "-2", "joe"), (Object)p2);
        StringUtilsTest.assertEquals((Object)StringUtils.argsToProperties(new String[]{"-fred", "-2", "joe"}, argNums), (Object)p1);
    }

    public void testValueSplit() {
        List<String> vals1 = StringUtils.valueSplit("arg(a,b),foo(d,e,f)", "[a-z]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        List<String> ans1 = Arrays.asList("arg(a,b)", "foo(d,e,f)");
        StringUtilsTest.assertEquals((String)"Split failed", ans1, vals1);
        vals1 = StringUtils.valueSplit("arg(a,b) , foo(d,e,f) , ", "[a-z]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        StringUtilsTest.assertEquals((String)"Split failed", ans1, vals1);
        vals1 = StringUtils.valueSplit(",arg(a,b),foo(d,e,f)", "[a-z]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        List<String> ans2 = Arrays.asList("", "arg(a,b)", "foo(d,e,f)");
        StringUtilsTest.assertEquals((String)"Split failed", ans2, vals1);
        List<String> vals3 = StringUtils.valueSplit("\"quoted,comma\",\"with \\\"\\\" quote\" , \"stuff\",or not,quoted,", "\"(?:[^\"\\\\]+|\\\\\")*\"|[^,\"]+", "\\s*,\\s*");
        List<String> ans3 = Arrays.asList("\"quoted,comma\"", "\"with \\\"\\\" quote\"", "\"stuff\"", "or not", "quoted");
        StringUtilsTest.assertEquals((String)"Split failed", ans3, vals3);
    }

    public void testLongestCommonSubstring() {
        StringUtilsTest.assertEquals((int)12, (int)StringUtils.longestCommonSubstring("Jo3seph Smarr!", "Joseph R Smarr"));
        StringUtilsTest.assertEquals((int)12, (int)StringUtils.longestCommonSubstring("Joseph R Smarr", "Jo3seph Smarr!"));
    }

    public void testEditDistance() {
        StringUtilsTest.assertEquals((int)4, (int)StringUtils.editDistance("Hi!", "Hi you!"));
        StringUtilsTest.assertEquals((int)5, (int)StringUtils.editDistance("Hi!", "Hi you!?"));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.editDistance("sdf", "asdf"));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.editDistance("asd", "asdf"));
        StringUtilsTest.assertEquals((int)4, (int)StringUtils.editDistance("Hi you!", "Hi!"));
        StringUtilsTest.assertEquals((int)5, (int)StringUtils.editDistance("Hi you!?", "Hi!"));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.editDistance("asdf", "asd"));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.editDistance("asdf", "sdf"));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.editDistance("Hi you!", "Hi Sir!"));
        StringUtilsTest.assertEquals((int)5, (int)StringUtils.editDistance("Hi you!", "Hi Sir!!!"));
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.editDistance("hello", "hlelo"));
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.editDistance("asdf", "adsf"));
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.editDistance("asdf", "sadf"));
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.editDistance("asdf", "asfd"));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.editDistance("", ""));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.editDistance("", "bar"));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.editDistance("foo", ""));
    }

    public void testSplitOnChar() {
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.splitOnChar("hello\tthere\tworld", '\t').length);
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.splitOnChar("hello\tworld", '\t').length);
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.splitOnChar("hello", '\t').length);
        StringUtilsTest.assertEquals((String)"hello", (String)StringUtils.splitOnChar("hello\tthere\tworld", '\t')[0]);
        StringUtilsTest.assertEquals((String)"there", (String)StringUtils.splitOnChar("hello\tthere\tworld", '\t')[1]);
        StringUtilsTest.assertEquals((String)"world", (String)StringUtils.splitOnChar("hello\tthere\tworld", '\t')[2]);
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.splitOnChar("hello\tthere\tworld\n", ' ').length);
        StringUtilsTest.assertEquals((String)"hello\tthere\tworld\n", (String)StringUtils.splitOnChar("hello\tthere\tworld\n", ' ')[0]);
        StringUtilsTest.assertEquals((int)5, (int)StringUtils.splitOnChar("a\tb\tc\td\te", '\t').length);
        StringUtilsTest.assertEquals((int)5, (int)StringUtils.splitOnChar("\t\t\t\t", '\t').length);
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.splitOnChar("\t\t\t\t", '\t')[0]);
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.splitOnChar("\t\t\t\t", '\t')[1]);
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.splitOnChar("\t\t\t\t", '\t')[4]);
    }

    public void testStringIsNullOrEmpty() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isNullOrEmpty(null));
        StringUtilsTest.assertTrue((boolean)StringUtils.isNullOrEmpty(""));
        StringUtilsTest.assertFalse((boolean)StringUtils.isNullOrEmpty(" "));
        StringUtilsTest.assertFalse((boolean)StringUtils.isNullOrEmpty("foo"));
    }

    public void testNormalize() {
        StringUtilsTest.assertEquals((String)"can't", (String)StringUtils.normalize("can't"));
        StringUtilsTest.assertEquals((String)"Beyonce", (String)StringUtils.normalize("Beyonc\u00e9"));
        StringUtilsTest.assertEquals((String)"krouzek", (String)StringUtils.normalize("krou\u017eek"));
        StringUtilsTest.assertEquals((String)"office", (String)StringUtils.normalize("o\ufb03ce"));
        StringUtilsTest.assertEquals((String)"DZ", (String)StringUtils.normalize("\u01c4"));
        StringUtilsTest.assertEquals((String)"1\u20444", (String)StringUtils.normalize("\u00bc"));
        StringUtilsTest.assertEquals((String)"\ud55c\uad6d\uc5b4", (String)StringUtils.normalize("\ud55c\uad6d\uc5b4"));
        StringUtilsTest.assertEquals((String)"\uc870\uc120\ub9d0", (String)StringUtils.normalize("\uc870\uc120\ub9d0"));
        StringUtilsTest.assertEquals((String)"\u304c", (String)StringUtils.normalize("\u304c"));
        StringUtilsTest.assertEquals((String)"\u304b", (String)StringUtils.normalize("\u304b"));
    }

    public void testCSV() {
        StringUtilsTest.assertEquals((String)"Bung test", (int)csvInputs.length, (int)csvOutputs.length);
        for (int i = 0; i < csvInputs.length; ++i) {
            Object[] answer = StringUtils.splitOnCharWithQuoting(csvInputs[i], ',', '\"', escapeInputs[i]);
            StringUtilsTest.assertTrue((String)("Bad CSV line handling of ex " + i + ": " + Arrays.toString(csvOutputs[i]) + " vs. " + Arrays.toString(answer)), (boolean)Arrays.equals(csvOutputs[i], answer));
        }
    }

    public void testGetCharacterNgrams() {
        this.testCharacterNgram("abc", 0, 0, new String[0]);
        this.testCharacterNgram("abc", 1, 1, "a", "b", "c");
        this.testCharacterNgram("abc", 2, 2, "ab", "bc");
        this.testCharacterNgram("abc", 1, 2, "a", "b", "c", "ab", "bc");
        this.testCharacterNgram("abc", 1, 3, "a", "b", "c", "ab", "bc", "abc");
        this.testCharacterNgram("abc", 1, 4, "a", "b", "c", "ab", "bc", "abc");
    }

    private void testCharacterNgram(String string, int min, int max, String ... expected) {
        System.out.println(this.makeSet(expected));
        System.out.println(StringUtils.getCharacterNgrams(string, min, max));
        StringUtilsTest.assertEquals(this.makeSet(expected), new HashSet<String>(StringUtils.getCharacterNgrams(string, min, max)));
    }

    @SafeVarargs
    private final <T> Set<T> makeSet(T ... elems) {
        return new HashSet<T>(Arrays.asList(elems));
    }

    public void testExpandEnvironmentVariables() {
        HashMap<String, String> env = new HashMap<String, String>(){
            {
                this.put("A", "[outA]");
                this.put("A_B", "[outA_B]");
                this.put("a_B", "[outa_B]");
                this.put("a_B45", "[outa_B45]");
                this.put("_A", "[out_A]");
                this.put("3A", "[out_3A]");
            }
        };
        StringUtilsTest.assertEquals((String)"xxx [outA] xxx", (String)StringUtils.expandEnvironmentVariables("xxx $A xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx[outA] xxx", (String)StringUtils.expandEnvironmentVariables("xxx$A xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx[outA]xxx", (String)StringUtils.expandEnvironmentVariables("xxx${A}xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx [outA_B] xxx", (String)StringUtils.expandEnvironmentVariables("xxx $A_B xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx [outa_B] xxx", (String)StringUtils.expandEnvironmentVariables("xxx $a_B xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx [outa_B45] xxx", (String)StringUtils.expandEnvironmentVariables("xxx $a_B45 xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx [out_A] xxx", (String)StringUtils.expandEnvironmentVariables("xxx $_A xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx $3A xxx", (String)StringUtils.expandEnvironmentVariables("xxx $3A xxx", (Map<String, String>)env));
        StringUtilsTest.assertEquals((String)"xxx  xxx", (String)StringUtils.expandEnvironmentVariables("xxx $UNDEFINED xxx", (Map<String, String>)env));
    }

    public void testDecodeArray() throws IOException {
        String tempFile1 = Files.createTempFile("test", "tmp", new FileAttribute[0]).toString();
        String tempFile2 = Files.createTempFile("test", "tmp", new FileAttribute[0]).toString();
        String[] decodedArray = StringUtils.decodeArray("'" + tempFile1 + "','" + tempFile2 + "'");
        StringUtilsTest.assertEquals((int)2, (int)decodedArray.length);
        StringUtilsTest.assertEquals((String)tempFile1, (String)decodedArray[0]);
        StringUtilsTest.assertEquals((String)tempFile2, (String)decodedArray[1]);
        String[] test10 = new String[]{"\"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt\"", "[\"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt\"]"};
        String[] ans10 = new String[]{"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt"};
        String[] test11 = new String[]{"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt", "[C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt]"};
        String[] ans11 = new String[]{"C:UsersBELLCH~1AppDataLocalTempbill-ie5804201486895318826regex_rules.txt"};
        for (String s : test10) {
            StringUtilsTest.assertEquals(Arrays.asList(ans10), Arrays.asList(StringUtils.decodeArray(s)));
        }
        for (String s : test11) {
            StringUtilsTest.assertEquals(Arrays.asList(ans11), Arrays.asList(StringUtils.decodeArray(s)));
        }
    }

    public void testRegexGroups() {
        List<String> ans = Arrays.asList("42", "123", "1965");
        StringUtilsTest.assertEquals(ans, StringUtils.regexGroups(Pattern.compile("(\\d+)\\D*(\\d+)\\D*(\\d+)"), "abc-x42!123   -1965."));
    }
}

