/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.util.TSVSentenceIterator;
import edu.stanford.nlp.util.TSVUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class TSVSentenceIteratorITest {
    public void testOnlyGloss() {
        ArrayList<1> entries = new ArrayList<1>();
        entries.add(new ArrayList<String>(){
            {
                this.add("124");
                this.add("docid1");
                this.add("1");
                this.add("This is a test document.");
            }
        });
        TSVSentenceIterator it = new TSVSentenceIterator(entries.iterator(), (List<TSVSentenceIterator.SentenceField>)new ArrayList<TSVSentenceIterator.SentenceField>(){
            {
                this.add(TSVSentenceIterator.SentenceField.ID);
                this.add(TSVSentenceIterator.SentenceField.DOC_ID);
                this.add(TSVSentenceIterator.SentenceField.SENTENCE_INDEX);
                this.add(TSVSentenceIterator.SentenceField.GLOSS);
            }
        });
        Sentence sentence = it.next();
        Assert.assertEquals((long)1L, (long)sentence.sentenceIndex());
        Assert.assertEquals((Object)"This is a test document.", (Object)sentence.text());
        Assert.assertEquals((Object)"docid1", sentence.asCoreMap(new Function[0]).get(CoreAnnotations.DocIDAnnotation.class));
        Assert.assertEquals((Object)"124", sentence.asCoreMap(new Function[0]).get(CoreAnnotations.SentenceIDAnnotation.class));
    }

    @Test
    public void testFullTokens() {
        ArrayList<3> entries = new ArrayList<3>();
        entries.add(new ArrayList<String>(){
            {
                this.add("3424");
                this.add("d2-s1-a1");
                this.add("0");
                this.add("{Chess,is,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,are,shooting,and,curling,-LRB-,which,\"\",\"\",in,fact,\"\",\"\",has,been,nicknamed,``,chess,on,ice,'',5,-RRB-,.}");
                this.add("{chess,be,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,be,shooting,and,curling,-lrb-,which,\"\",\"\",in,fact,\"\",\"\",have,be,nickname,``,chess,on,ice,'',5,-rrb-,.}");
                this.add("{NN,VBZ,RB,DT,RB,JJ,NN,\"\",\"\",RB,DT,VBP,JJ,CC,NN,-LRB-,WDT,\"\",\"\",IN,NN,\"\",\"\",VBZ,VBN,VBN,``,NN,IN,NN,'',LS,-RRB-,.}");
                this.add("{O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,NUMBER,O,O}");
                this.add("{0,6,9,13,15,29,38,43,45,49,57,61,70,74,82,83,88,90,93,97,99,103,108,118,119,125,128,131,132,133,134}");
                this.add("{5,8,12,14,28,37,43,44,48,56,60,69,73,81,83,88,89,92,97,98,102,107,117,119,124,127,131,132,133,134,135}");
                this.add("Chess is not a predominantly physical sport, yet neither are shooting and curling (which, in fact, has been nicknamed \u201cchess on ice\u201d5).");
            }
        });
        TSVSentenceIterator it = new TSVSentenceIterator(entries.iterator(), (List<TSVSentenceIterator.SentenceField>)new ArrayList<TSVSentenceIterator.SentenceField>(){
            {
                this.add(TSVSentenceIterator.SentenceField.ID);
                this.add(TSVSentenceIterator.SentenceField.DOC_ID);
                this.add(TSVSentenceIterator.SentenceField.SENTENCE_INDEX);
                this.add(TSVSentenceIterator.SentenceField.WORDS);
                this.add(TSVSentenceIterator.SentenceField.LEMMAS);
                this.add(TSVSentenceIterator.SentenceField.POS_TAGS);
                this.add(TSVSentenceIterator.SentenceField.NER_TAGS);
                this.add(TSVSentenceIterator.SentenceField.DOC_CHAR_BEGIN);
                this.add(TSVSentenceIterator.SentenceField.DOC_CHAR_END);
                this.add(TSVSentenceIterator.SentenceField.GLOSS);
            }
        });
        Sentence sentence = it.next();
        Assert.assertEquals((Object)"3424", (Object)sentence.sentenceid().orElse("-1"));
        Assert.assertEquals((Object)"d2-s1-a1", (Object)sentence.document.docid().orElse("???"));
        Assert.assertEquals((long)0L, (long)sentence.sentenceIndex());
        Assert.assertEquals((Object)"Chess is not a predominantly physical sport, yet neither are shooting and curling (which, in fact, has been nicknamed \u201cchess on ice\u201d5).", (Object)sentence.text());
        Assert.assertArrayEquals((Object[])new String[]{"Chess", "is", "not", "a", "predominantly", "physical", "sport", ",", "yet", "neither", "are", "shooting", "and", "curling", "-LRB-", "which", ",", "in", "fact", ",", "has", "been", "nicknamed", "``", "chess", "on", "ice", "''", "5", "-RRB-", "."}, (Object[])sentence.words().toArray());
        Assert.assertArrayEquals((Object[])new String[]{"chess", "be", "not", "a", "predominantly", "physical", "sport", ",", "yet", "neither", "be", "shooting", "and", "curling", "-lrb-", "which", ",", "in", "fact", ",", "have", "be", "nickname", "``", "chess", "on", "ice", "''", "5", "-rrb-", "."}, (Object[])sentence.lemmas().toArray());
        Assert.assertArrayEquals((Object[])new String[]{"NN", "VBZ", "RB", "DT", "RB", "JJ", "NN", ",", "RB", "DT", "VBP", "JJ", "CC", "NN", "-LRB-", "WDT", ",", "IN", "NN", ",", "VBZ", "VBN", "VBN", "``", "NN", "IN", "NN", "''", "LS", "-RRB-", "."}, (Object[])sentence.posTags().toArray());
        Assert.assertArrayEquals((Object[])new String[]{"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "NUMBER", "O", "O"}, (Object[])sentence.nerTags().toArray());
        Assert.assertArrayEquals((Object[])new Integer[]{0, 6, 9, 13, 15, 29, 38, 43, 45, 49, 57, 61, 70, 74, 82, 83, 88, 90, 93, 97, 99, 103, 108, 118, 119, 125, 128, 131, 132, 133, 134}, (Object[])sentence.characterOffsetBegin().toArray());
        Assert.assertArrayEquals((Object[])new Integer[]{5, 8, 12, 14, 28, 37, 43, 44, 48, 56, 60, 69, 73, 81, 83, 88, 89, 92, 97, 98, 102, 107, 117, 119, 124, 127, 131, 132, 133, 134, 135}, (Object[])sentence.characterOffsetEnd().toArray());
    }

    @Test
    public void testParseArray() {
        String in = "{Chess,is,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,are,shooting,and,curling,-LRB-,which,\"\",\"\",in,fact,\"\",\"\",has,been,nicknamed,``,chess,on,ice,'',5,-RRB-,.}";
        Object[] out2 = new String[]{"Chess", "is", "not", "a", "predominantly", "physical", "sport", ",", "yet", "neither", "are", "shooting", "and", "curling", "-LRB-", "which", ",", "in", "fact", ",", "has", "been", "nicknamed", "``", "chess", "on", "ice", "''", "5", "-RRB-", "."};
        Assert.assertArrayEquals((Object[])out2, (Object[])TSVUtils.parseArray(in).toArray());
    }

    @Test
    public void testParseTrees() {
        ArrayList<5> entries = new ArrayList<5>();
        entries.add(new ArrayList<String>(){
            {
                this.add("3424");
                this.add("d2-s1-a1");
                this.add("0");
                this.add("{Chess,is,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,are,shooting,and,curling,-LRB-,which,\"\",\"\",in,fact,\"\",\"\",has,been,nicknamed,``,chess,on,ice,'',5,-RRB-,.}");
                this.add("{chess,be,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,be,shooting,and,curling,-lrb-,which,\"\",\"\",in,fact,\"\",\"\",have,be,nickname,``,chess,on,ice,'',5,-rrb-,.}");
                this.add("{NN,VBZ,RB,DT,RB,JJ,NN,\"\",\"\",RB,DT,VBP,JJ,CC,NN,-LRB-,WDT,\"\",\"\",IN,NN,\"\",\"\",VBZ,VBN,VBN,``,NN,IN,NN,'',LS,-RRB-,.}");
                this.add("{O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,NUMBER,O,O}");
                this.add("{0,6,9,13,15,29,38,43,45,49,57,61,70,74,82,83,88,90,93,97,99,103,108,118,119,125,128,131,132,133,134}");
                this.add("{5,8,12,14,28,37,43,44,48,56,60,69,73,81,83,88,89,92,97,98,102,107,117,119,124,127,131,132,133,134,135}");
                this.add("[{\"\"dependent\"\": 7, \"\"dep\"\": \"\"ROOT\"\", \"\"governorGloss\"\": \"\"ROOT\"\", \"\"governor\"\": 0, \"\"dependentGloss\"\": \"\"sport\"\"}, {\"\"dependent\"\": 1, \"\"dep\"\": \"\"nsubj\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"Chess\"\"}, {\"\"dependent\"\": 2, \"\"dep\"\": \"\"cop\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"is\"\"}, {\"\"dependent\"\": 3, \"\"dep\"\": \"\"neg\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"not\"\"}, {\"\"dependent\"\": 4, \"\"dep\"\": \"\"det\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"a\"\"}, {\"\"dependent\"\": 5, \"\"dep\"\": \"\"advmod\"\", \"\"governorGloss\"\": \"\"physical\"\", \"\"governor\"\": 6, \"\"dependentGloss\"\": \"\"predominantly\"\"}, {\"\"dependent\"\": 6, \"\"dep\"\": \"\"amod\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"physical\"\"}, {\"\"dependent\"\": 9, \"\"dep\"\": \"\"advmod\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"yet\"\"}, {\"\"dependent\"\": 10, \"\"dep\"\": \"\"nsubj\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"neither\"\"}, {\"\"dependent\"\": 11, \"\"dep\"\": \"\"cop\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"are\"\"}, {\"\"dependent\"\": 12, \"\"dep\"\": \"\"parataxis\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"shooting\"\"}, {\"\"dependent\"\": 13, \"\"dep\"\": \"\"cc\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"and\"\"}, {\"\"dependent\"\": 14, \"\"dep\"\": \"\"parataxis\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"curling\"\"}, {\"\"dependent\"\": 14, \"\"dep\"\": \"\"conj:and\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"curling\"\"}, {\"\"dependent\"\": 16, \"\"dep\"\": \"\"nsubjpass\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"which\"\"}, {\"\"dependent\"\": 18, \"\"dep\"\": \"\"case\"\", \"\"governorGloss\"\": \"\"fact\"\", \"\"governor\"\": 19, \"\"dependentGloss\"\": \"\"in\"\"}, {\"\"dependent\"\": 19, \"\"dep\"\": \"\"nmod:in\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"fact\"\"}, {\"\"dependent\"\": 21, \"\"dep\"\": \"\"aux\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"has\"\"}, {\"\"dependent\"\": 22, \"\"dep\"\": \"\"auxpass\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"been\"\"}, {\"\"dependent\"\": 23, \"\"dep\"\": \"\"dep\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"nicknamed\"\"}, {\"\"dependent\"\": 25, \"\"dep\"\": \"\"dobj\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"chess\"\"}, {\"\"dependent\"\": 26, \"\"dep\"\": \"\"case\"\", \"\"governorGloss\"\": \"\"ice\"\", \"\"governor\"\": 27, \"\"dependentGloss\"\": \"\"on\"\"}, {\"\"dependent\"\": 27, \"\"dep\"\": \"\"nmod:on\"\", \"\"governorGloss\"\": \"\"chess\"\", \"\"governor\"\": 25, \"\"dependentGloss\"\": \"\"ice\"\"}, {\"\"dependent\"\": 29, \"\"dep\"\": \"\"amod\"\", \"\"governorGloss\"\": \"\"chess\"\", \"\"governor\"\": 25, \"\"dependentGloss\"\": \"\"5\"\"}]");
                this.add("Chess is not a predominantly physical sport, yet neither are shooting and curling (which, in fact, has been nicknamed \u201cchess on ice\u201d5).");
            }
        });
        TSVSentenceIterator it = new TSVSentenceIterator(entries.iterator(), (List<TSVSentenceIterator.SentenceField>)new ArrayList<TSVSentenceIterator.SentenceField>(){
            {
                this.add(TSVSentenceIterator.SentenceField.ID);
                this.add(TSVSentenceIterator.SentenceField.DOC_ID);
                this.add(TSVSentenceIterator.SentenceField.SENTENCE_INDEX);
                this.add(TSVSentenceIterator.SentenceField.WORDS);
                this.add(TSVSentenceIterator.SentenceField.LEMMAS);
                this.add(TSVSentenceIterator.SentenceField.POS_TAGS);
                this.add(TSVSentenceIterator.SentenceField.NER_TAGS);
                this.add(TSVSentenceIterator.SentenceField.DOC_CHAR_BEGIN);
                this.add(TSVSentenceIterator.SentenceField.DOC_CHAR_END);
                this.add(TSVSentenceIterator.SentenceField.DEPENDENCIES_BASIC);
                this.add(TSVSentenceIterator.SentenceField.GLOSS);
            }
        });
        Sentence sentence = it.next();
        sentence.dependencyGraph();
        sentence.openieTriples();
    }
}

